/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.message;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.Global;
import org.voovan.tools.security.THash;

public class HttpItem {
    public static final int HTTP_ITEM_MAX_LENGTH = 1024;
    public static final Map<String, HttpItem> HTTP_ITEM_MAP = new ConcurrentHashMap<String, HttpItem>();
    public static final Map[] HTTP_ITEM_LENGTH_LIST = new Map[1024];
    public static final HttpItem EMPTY;
    private final byte[] bytes;
    private final String string;
    private int hashcode = 0;

    public HttpItem(String string) {
        this.string = string;
        this.bytes = string.getBytes();
        this.hashcode = THash.hashTime31(this.bytes, 0, this.bytes.length);
        HTTP_ITEM_MAP.putIfAbsent(string, this);
        HTTP_ITEM_LENGTH_LIST[this.bytes.length].put(this.hashcode, this);
    }

    public HttpItem(byte[] bytesArg, int offset, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(bytesArg, offset, bytes, 0, length);
        this.bytes = bytes;
        this.string = new String(bytes, Global.CS_ASCII);
        this.hashcode = THash.hashTime31(bytes, 0, length);
        HTTP_ITEM_MAP.putIfAbsent(this.string, this);
        HTTP_ITEM_LENGTH_LIST[bytes.length].put(this.hashcode, this);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getString() {
        return this.string;
    }

    public int getHashCode() {
        return this.hashcode;
    }

    public static HttpItem getHttpItem(byte[] bytes, int offset, int length) {
        int hashcode = THash.hashTime31(bytes, offset, length);
        HttpItem httpItem = (HttpItem)HTTP_ITEM_LENGTH_LIST[length].get(hashcode);
        if (httpItem == null) {
            httpItem = new HttpItem(bytes, offset, length);
        }
        return httpItem;
    }

    static {
        for (int i = 0; i < HTTP_ITEM_LENGTH_LIST.length; ++i) {
            HttpItem.HTTP_ITEM_LENGTH_LIST[i] = new ConcurrentHashMap();
        }
        EMPTY = new HttpItem("");
    }
}

