/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.extend.socketio;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.http.extend.engineio.EIOHandler;
import org.voovan.http.extend.engineio.EIOSession;
import org.voovan.http.extend.socketio.SIODispatcher;
import org.voovan.http.extend.socketio.SIOHandler;
import org.voovan.http.extend.socketio.SIOPacket;
import org.voovan.http.extend.socketio.SIOParser;
import org.voovan.http.websocket.exception.WebSocketFilterException;
import org.voovan.network.exception.SendMessageException;
import org.voovan.tools.TObject;
import org.voovan.tools.json.JSON;

public class SIOSession {
    private SIODispatcher sioDispatcher;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private EIOSession eioSession;
    private String nsp;

    public SIOSession(EIOSession eioSession, SIODispatcher sioDispatcher, String nsp) {
        this.eioSession = eioSession;
        this.sioDispatcher = sioDispatcher;
        this.nsp = nsp;
    }

    protected void getEioSession(EIOHandler eioHandler) {
        this.eioSession = this.eioSession;
    }

    protected void getNsp(String nsp) {
        this.nsp = nsp;
    }

    protected void getSioDispatcher(SIODispatcher sioDispatcher) {
        this.sioDispatcher = sioDispatcher;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean containAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void emit(String event, SIOHandler sioHandler, Object ... params) throws SendMessageException, WebSocketFilterException {
        this.sioDispatcher.on(event, sioHandler);
        ArrayList<String> args = new ArrayList<String>();
        args.add(event);
        args.addAll(TObject.asList(params));
        SIOPacket sioPacket = new SIOPacket(2, this.nsp, JSON.toJSON(args));
        this.eioSession.send(SIOParser.encode(sioPacket));
    }
}

