/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.extend.socketio;

import org.voovan.http.extend.ParserException;
import org.voovan.http.extend.socketio.SIOPacket;
import org.voovan.tools.TString;
import org.voovan.tools.log.Logger;

public class SIOParser {
    private static final char SPLITER = ',';
    private static final char DATA_BEGIN = '[';

    public static boolean isSocketIOMessage(String msg) {
        return TString.regexMatch(msg, "(^[0-6].*?,(\\d*\\[.*\\])?)|(^[0-6]\\[.*\\])") > 0;
    }

    public static SIOPacket decode(String msg) throws ParserException {
        String seqValue;
        SIOPacket packet = new SIOPacket();
        StringBuilder stringBuilder = new StringBuilder();
        char c = msg.charAt(0);
        int socketType = c - 48;
        if (!TString.isNumber(String.valueOf(c), 10)) {
            throw new ParserException("The socket.io packet first char must be number");
        }
        if (socketType < 0 || socketType > 6) {
            throw new ParserException("The socket.io packet first char must be exists in [0...6]");
        }
        packet.setSocketType(socketType);
        int dotPosition = msg.indexOf(44);
        int dataPosition = msg.indexOf(91);
        if (dotPosition > 0 && dataPosition < 0 || dotPosition < dataPosition) {
            packet.setNsp(msg.substring(1, dotPosition));
        }
        if (dotPosition > 0 && dataPosition > 0 && dotPosition < dataPosition && TString.isNumber(seqValue = msg.substring(dotPosition + 1, dotPosition + 2), 10)) {
            packet.setSeq(Integer.valueOf(msg.substring(dotPosition + 1, dotPosition + 2)));
        }
        if (dataPosition > 0) {
            dataPosition = dataPosition < 0 ? 1 : dataPosition;
            packet.setData(msg.substring(dataPosition));
        }
        return packet;
    }

    public static String encode(SIOPacket packet) {
        StringBuilder msg = new StringBuilder();
        msg.append(packet.getSocketType());
        if (packet.getNsp() != null) {
            msg.append(packet.getNsp());
            msg.append(',');
        }
        if (packet.getSeq() != -1) {
            msg.append(packet.getSeq());
        }
        if (packet.getData() != null) {
            msg.append(packet.getData());
        }
        return msg.toString();
    }

    public static void main(String[] args) throws ParserException {
        String mm = "2/socketio,0[\"show\", \"kkkk\"]";
        Logger.simple(SIOParser.isSocketIOMessage(mm));
        SIOPacket packet = SIOParser.decode(mm);
        Logger.simple(SIOParser.encode(packet));
        mm = "2[\"show\", \"kkkk\"]";
        Logger.simple(SIOParser.isSocketIOMessage(mm));
        packet = SIOParser.decode(mm);
        Logger.simple(SIOParser.encode(packet));
        mm = "0/socketio,";
        packet = SIOParser.decode(mm);
        Logger.simple(SIOParser.isSocketIOMessage(mm));
        Logger.simple(SIOParser.encode(packet));
        mm = "2/socketio,[\"show\", \"kkkk\"]";
        Logger.simple(SIOParser.isSocketIOMessage(mm));
        packet = SIOParser.decode(mm);
        Logger.simple(SIOParser.encode(packet));
    }
}

