/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.extend.socketio;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.voovan.http.extend.engineio.Config;
import org.voovan.http.extend.engineio.EIODispatcher;
import org.voovan.http.extend.engineio.EIOHandler;
import org.voovan.http.extend.socketio.SIOHandler;
import org.voovan.http.extend.socketio.SIOPacket;
import org.voovan.http.extend.socketio.SIOParser;
import org.voovan.tools.json.JSON;

public class SIODispatcher
extends EIODispatcher {
    private Map<String, SIOHandler> sioEventHandlers = new HashMap<String, SIOHandler>();

    public SIODispatcher(Config config) {
        super(config);
        super.on("message", new MessageHandler(this));
    }

    public SIODispatcher on(String Event2, SIOHandler sioHandler) {
        this.sioEventHandlers.put(Event2, sioHandler);
        return this;
    }

    public class MessageHandler
    extends EIOHandler {
        private SIODispatcher sioDispatcher;

        public MessageHandler(SIODispatcher sioDispatcher) {
            this.sioDispatcher = sioDispatcher;
        }

        public MessageHandler() {
        }

        @Override
        public String execute(String msg) {
            try {
                if (SIOParser.isSocketIOMessage(msg)) {
                    SIOHandler sioHandler;
                    Object[] args;
                    String event;
                    List argsList;
                    SIOPacket sioPacket = SIOParser.decode(msg);
                    if (sioPacket.getSocketType() == 0) {
                        SIOHandler sioHandler2 = (SIOHandler)SIODispatcher.this.sioEventHandlers.get("connect");
                        sioHandler2.setNsp(sioPacket.getNsp());
                        sioHandler2.setEioHandler(this);
                        sioHandler2.setSioDispatcher(this.sioDispatcher);
                        if (sioHandler2 != null) {
                            sioHandler2.execute(null);
                        }
                        return SIOParser.encode(sioPacket);
                    }
                    if (sioPacket.getSocketType() == 1) {
                        SIOHandler sioHandler3 = (SIOHandler)SIODispatcher.this.sioEventHandlers.get("disconnect");
                        sioHandler3.setNsp(sioPacket.getNsp());
                        sioHandler3.setEioHandler(this);
                        sioHandler3.setSioDispatcher(this.sioDispatcher);
                        if (sioHandler3 != null) {
                            sioHandler3.execute(null);
                        }
                        return SIOParser.encode(sioPacket);
                    }
                    if (sioPacket.getSocketType() == 4) {
                        SIOHandler sioHandler4 = (SIOHandler)SIODispatcher.this.sioEventHandlers.get("error");
                        sioHandler4.setNsp(sioPacket.getNsp());
                        sioHandler4.setEioHandler(this);
                        sioHandler4.setSioDispatcher(this.sioDispatcher);
                        if (sioHandler4 != null) {
                            sioHandler4.execute(null);
                        }
                        return SIOParser.encode(sioPacket);
                    }
                    if (sioPacket.getSocketType() == 2) {
                        Object[] result;
                        argsList = (List)JSON.parse(sioPacket.getData());
                        event = (String)argsList.get(0);
                        argsList.remove(0);
                        args = argsList.toArray(new Object[0]);
                        sioHandler = (SIOHandler)SIODispatcher.this.sioEventHandlers.get(event);
                        sioHandler.setNsp(sioPacket.getNsp());
                        sioHandler.setEioHandler(this);
                        sioHandler.setSioDispatcher(this.sioDispatcher);
                        if (sioHandler != null && (result = sioHandler.execute(args)) != null) {
                            if (!result.getClass().isArray()) {
                                result = new Object[]{result};
                            }
                            sioPacket.setSocketType(3);
                            sioPacket.setData(JSON.toJSON(result));
                            return SIOParser.encode(sioPacket);
                        }
                    }
                    if (sioPacket.getSocketType() == 3) {
                        argsList = (List)JSON.parse(sioPacket.getData());
                        event = (String)argsList.get(0);
                        argsList.remove(0);
                        args = argsList.toArray(new Object[0]);
                        sioHandler = (SIOHandler)SIODispatcher.this.sioEventHandlers.get("ack_" + event);
                        sioHandler.setNsp(sioPacket.getNsp());
                        sioHandler.setEioHandler(this);
                        sioHandler.setSioDispatcher(this.sioDispatcher);
                        if (sioHandler != null) {
                            sioHandler.execute(args);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

