/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.extend.engineio;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.voovan.http.extend.engineio.EIOHandler;
import org.voovan.http.extend.engineio.EIOPacket;
import org.voovan.http.extend.engineio.EIOParser;
import org.voovan.http.websocket.WebSocketSession;
import org.voovan.http.websocket.exception.WebSocketFilterException;
import org.voovan.network.exception.SendMessageException;

public class EIOSession {
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private WebSocketSession webSocketSession;
    private EIOHandler eioHandler;

    public EIOSession(WebSocketSession webSocketSession, EIOHandler eioHandler) {
        this.webSocketSession = webSocketSession;
        this.eioHandler = eioHandler;
    }

    protected void getEioHandler(EIOHandler eioHandler) {
        this.eioHandler = eioHandler;
    }

    protected WebSocketSession getWebSocketSession() {
        return this.webSocketSession;
    }

    public void setWebSocketSession(WebSocketSession webSocketSession) {
        this.webSocketSession = webSocketSession;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean containAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void send(String msg) throws SendMessageException, WebSocketFilterException {
        this.webSocketSession.send(EIOParser.encode(new EIOPacket(4, msg)));
    }
}

