/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.extend.engineio;

import java.util.HashMap;
import java.util.Map;
import org.voovan.http.extend.ParserException;
import org.voovan.http.extend.engineio.Config;
import org.voovan.http.extend.engineio.EIOHandler;
import org.voovan.http.extend.engineio.EIOPacket;
import org.voovan.http.extend.engineio.EIOParser;
import org.voovan.http.websocket.WebSocketRouter;
import org.voovan.http.websocket.WebSocketSession;
import org.voovan.http.websocket.filter.StringFilter;

public class EIODispatcher
extends WebSocketRouter {
    private Config config;
    private Map<String, EIOHandler> eioEventHandlers;

    public EIODispatcher(Config config) {
        this.config = config;
        this.eioEventHandlers = new HashMap<String, EIOHandler>();
        this.addFilterChain(new StringFilter());
    }

    public EIODispatcher on(String Event2, EIOHandler eioHandler) {
        this.eioEventHandlers.put(Event2, eioHandler);
        return this;
    }

    @Override
    public Object onOpen(WebSocketSession session) {
        EIOHandler eioHandler = this.eioEventHandlers.get("connection");
        if (eioHandler != null) {
            eioHandler.setWebSocketSession(session);
            eioHandler.execute(null);
        }
        return EIOParser.encode(new EIOPacket(0, this.config.toString()));
    }

    @Override
    public Object onRecived(WebSocketSession session, Object obj) {
        try {
            if (EIOParser.isEngineIOMessage((String)obj)) {
                EIOPacket eioPacket = EIOParser.decode((String)obj);
                if (eioPacket.getEngineType() == 4) {
                    EIOHandler eioHandler = this.eioEventHandlers.get("message");
                    if (eioHandler != null) {
                        eioHandler.setWebSocketSession(session);
                        String result = eioHandler.execute(eioPacket.getData());
                        if (result != null) {
                            eioPacket.setData(result);
                            return EIOParser.encode(eioPacket);
                        }
                    }
                } else {
                    EIOHandler eioHandler;
                    if (eioPacket.getEngineType() == 2) {
                        EIOHandler eioHandler2 = this.eioEventHandlers.get("ping");
                        if (eioHandler2 != null) {
                            eioHandler2.setWebSocketSession(session);
                            eioHandler2.execute(eioPacket.getData());
                        }
                        eioPacket.setEngineType(3);
                        return EIOParser.encode(eioPacket);
                    }
                    if (eioPacket.getEngineType() == 3) {
                        EIOHandler eioHandler3 = this.eioEventHandlers.get("pong");
                        if (eioHandler3 != null) {
                            eioHandler3.setWebSocketSession(session);
                            eioHandler3.execute(eioPacket.getData());
                        }
                        eioPacket.setEngineType(2);
                        return EIOParser.encode(eioPacket);
                    }
                    if (eioPacket.getEngineType() == 6 && (eioHandler = this.eioEventHandlers.get("noop")) != null) {
                        eioHandler.setWebSocketSession(session);
                        String result = eioHandler.execute(null);
                        return EIOParser.encode(new EIOPacket(4, result));
                    }
                }
                return null;
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void onSent(WebSocketSession session, Object obj) {
    }

    @Override
    public void onClose(WebSocketSession session) {
        EIOHandler eioHandler = this.eioEventHandlers.get("close");
        if (eioHandler != null) {
            eioHandler.setWebSocketSession(session);
            eioHandler.execute(null);
        }
    }
}

