/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.client;

import java.nio.ByteBuffer;
import org.voovan.Global;
import org.voovan.http.client.HttpClient;
import org.voovan.http.websocket.WebSocketFrame;
import org.voovan.http.websocket.WebSocketRouter;
import org.voovan.http.websocket.WebSocketSession;
import org.voovan.http.websocket.exception.WebSocketFilterException;
import org.voovan.network.IoHandler;
import org.voovan.network.IoSession;
import org.voovan.network.SocketContext;
import org.voovan.network.exception.SendMessageException;
import org.voovan.tools.buffer.ByteBufferChannel;
import org.voovan.tools.hashwheeltimer.HashWheelTask;
import org.voovan.tools.log.Logger;

public class WebSocketHandler
implements IoHandler {
    private WebSocketRouter webSocketRouter;
    private HttpClient httpClient;
    private WebSocketSession webSocketSession;

    public WebSocketHandler(HttpClient httpClient, WebSocketSession webSocketSession, WebSocketRouter webSocketRouter) {
        this.webSocketRouter = webSocketRouter;
        this.httpClient = httpClient;
        this.webSocketSession = webSocketSession;
    }

    @Override
    public Object onConnect(IoSession session) {
        return null;
    }

    @Override
    public void onDisconnect(IoSession session) {
        this.webSocketRouter.onClose(this.webSocketSession);
        ByteBufferChannel byteBufferChannel = (ByteBufferChannel)session.getAttribute("WebSocketByteBufferChannel");
        if (byteBufferChannel != null && !byteBufferChannel.isReleased()) {
            byteBufferChannel.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object onReceive(IoSession session, Object obj) {
        WebSocketFrame reqWebSocketFrame = null;
        WebSocketFrame respWebSocketFrame = null;
        if (!(obj instanceof WebSocketFrame)) {
            return null;
        }
        reqWebSocketFrame = (WebSocketFrame)obj;
        ByteBufferChannel byteBufferChannel = null;
        if (!session.containAttribute("WebSocketByteBufferChannel")) {
            byteBufferChannel = new ByteBufferChannel(((SocketContext)session.socketContext()).getReadBufferSize());
            session.setAttribute("WebSocketByteBufferChannel", byteBufferChannel);
        } else {
            byteBufferChannel = (ByteBufferChannel)session.getAttribute("WebSocketByteBufferChannel");
        }
        if (reqWebSocketFrame.getOpcode() == WebSocketFrame.Opcode.CLOSING) {
            return WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.CLOSING, true, reqWebSocketFrame.getFrameData());
        }
        if (reqWebSocketFrame.getOpcode() == WebSocketFrame.Opcode.PING) {
            return WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.PONG, true, reqWebSocketFrame.getFrameData());
        }
        if (reqWebSocketFrame.getOpcode() == WebSocketFrame.Opcode.PONG) {
            final IoSession poneSession = session;
            Global.getHashWheelTimer().addTask(new HashWheelTask(){

                @Override
                public void run() {
                    try {
                        Logger.simple("PONG");
                        poneSession.syncSend(WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.PING, true, null));
                    }
                    catch (SendMessageException e) {
                        poneSession.close();
                        Logger.error("WebSocket Pong event writeToChannel Ping frame error", e);
                    }
                    finally {
                        this.cancel();
                    }
                }
            }, ((SocketContext)poneSession.socketContext()).getReadTimeout() / 3 / 1000);
        } else if (reqWebSocketFrame.getOpcode() == WebSocketFrame.Opcode.CONTINUOUS) {
            byteBufferChannel.writeEnd(reqWebSocketFrame.getFrameData());
        } else if (reqWebSocketFrame.getOpcode() == WebSocketFrame.Opcode.TEXT || reqWebSocketFrame.getOpcode() == WebSocketFrame.Opcode.BINARY) {
            Object result = null;
            byteBufferChannel.writeEnd(reqWebSocketFrame.getFrameData());
            try {
                try {
                    result = this.webSocketRouter.filterDecoder(this.webSocketSession, byteBufferChannel.getByteBuffer());
                    result = this.webSocketRouter.onRecived(this.webSocketSession, result);
                }
                finally {
                    byteBufferChannel.compact();
                    byteBufferChannel.clear();
                }
                if (result != null) {
                    ByteBuffer buffer = (ByteBuffer)this.webSocketRouter.filterEncoder(this.webSocketSession, result);
                    respWebSocketFrame = WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.TEXT, true, buffer);
                }
            }
            catch (WebSocketFilterException e) {
                Logger.error(e);
            }
        }
        return respWebSocketFrame;
    }

    @Override
    public void onSent(IoSession session, Object obj) {
        WebSocketFrame webSocketFrame = (WebSocketFrame)obj;
        if (webSocketFrame.getOpcode() == WebSocketFrame.Opcode.CLOSING) {
            session.close();
            return;
        }
        if (webSocketFrame.getOpcode() != WebSocketFrame.Opcode.PING && webSocketFrame.getOpcode() != WebSocketFrame.Opcode.PONG && webSocketFrame.getOpcode() != WebSocketFrame.Opcode.CLOSING) {
            ByteBuffer data = webSocketFrame.getFrameData();
            try {
                obj = this.webSocketRouter.filterDecoder(this.webSocketSession, data);
                this.webSocketRouter.onSent(this.webSocketSession, obj);
            }
            catch (WebSocketFilterException e) {
                Logger.error(e);
            }
        }
    }

    @Override
    public void onFlush(IoSession session) {
    }

    @Override
    public void onException(IoSession session, Exception e) {
        Logger.error(e);
    }

    @Override
    public void onIdle(IoSession session) {
    }
}

