/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.voovan.http.HttpRequestType;
import org.voovan.http.HttpSessionParam;
import org.voovan.http.client.HttpClient;
import org.voovan.http.message.HttpParser;
import org.voovan.http.message.Response;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.server.WebServerHandler;
import org.voovan.http.websocket.WebSocketFrame;
import org.voovan.network.IoFilter;
import org.voovan.network.IoSession;
import org.voovan.network.SocketContext;
import org.voovan.network.exception.IoFilterException;
import org.voovan.tools.buffer.ByteBufferChannel;
import org.voovan.tools.buffer.TByteBuffer;
import org.voovan.tools.log.Logger;

public class HttpClientFilter
implements IoFilter {
    private HttpClient httpClient;

    public HttpClientFilter(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Object encode(IoSession session, Object object) {
        if (object instanceof WebSocketFrame) {
            return ((WebSocketFrame)object).toByteBuffer();
        }
        if (object instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)object;
            try {
                httpRequest.send();
            }
            catch (IOException e) {
                Logger.error(e);
            }
            return TByteBuffer.EMPTY_BYTE_BUFFER;
        }
        return null;
    }

    @Override
    public Object decode(IoSession session, Object object) throws IoFilterException {
        try {
            if (object instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)object;
                if (byteBuffer.limit() == 0) {
                    session.enabledMessageSpliter(false);
                }
                ByteBufferChannel byteBufferChannel = session.getReadByteBufferChannel();
                if (HttpRequestType.WEBSOCKET.equals(WebServerHandler.getAttribute(session, HttpSessionParam.TYPE))) {
                    WebSocketFrame webSocketFrame = WebSocketFrame.parse((ByteBuffer)object);
                    return webSocketFrame;
                }
                Response response = HttpParser.parseResponse(session, byteBufferChannel, ((SocketContext)session.socketContext()).getReadTimeout());
                if (response.protocol().getStatus() == 101 && response.header().get("Sec-WebSocket-Accept").equals("F2D56gI8wPj3dJw+vgY0KFJEtIM=")) {
                    this.httpClient.initWebSocket();
                }
                Response response2 = response;
                return response2;
            }
        }
        catch (IOException e) {
            throw new IoFilterException("HttpClientFilter decode Error. " + e.getMessage(), e);
        }
        finally {
            session.enabledMessageSpliter(true);
        }
        return null;
    }
}

