/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.http.client;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.voovan.http.HttpRequestType;
import org.voovan.http.HttpSessionParam;
import org.voovan.http.client.HttpClientFilter;
import org.voovan.http.client.WebSocketHandler;
import org.voovan.http.message.Request;
import org.voovan.http.message.Response;
import org.voovan.http.message.packet.Cookie;
import org.voovan.http.message.packet.Header;
import org.voovan.http.message.packet.Part;
import org.voovan.http.server.HttpRequest;
import org.voovan.http.websocket.WebSocketFrame;
import org.voovan.http.websocket.WebSocketRouter;
import org.voovan.http.websocket.WebSocketSession;
import org.voovan.http.websocket.WebSocketType;
import org.voovan.http.websocket.exception.WebSocketFilterException;
import org.voovan.network.IoSession;
import org.voovan.network.SSLManager;
import org.voovan.network.exception.ReadMessageException;
import org.voovan.network.exception.SendMessageException;
import org.voovan.network.messagesplitter.HttpMessageSplitter;
import org.voovan.network.tcp.TcpSession;
import org.voovan.network.tcp.TcpSocket;
import org.voovan.tools.TEnv;
import org.voovan.tools.TObject;
import org.voovan.tools.TString;
import org.voovan.tools.log.Logger;

public class HttpClient
implements Closeable {
    private TcpSocket socket;
    private HttpRequest httpRequest;
    private Map<String, Object> parameters;
    private String charset = "UTF-8";
    private String urlString;
    private boolean isSSL = false;
    private boolean isWebSocket = false;
    private WebSocketRouter webSocketRouter;
    private String hostString;

    public HttpClient(String urlString) {
        this.urlString = urlString;
        this.init(urlString, 5);
    }

    public HttpClient(String urlString, int timeOut) {
        this.urlString = urlString;
        this.init(urlString, timeOut);
    }

    public HttpClient(String urlString, String charset, int timeOut) {
        this.urlString = urlString;
        this.charset = charset;
        this.init(urlString, timeOut);
    }

    public HttpClient(String urlString, String charset) {
        this.urlString = urlString;
        this.charset = charset;
        this.init(urlString, 5);
    }

    private boolean trySSL(String urlString) {
        boolean isSSL = urlString.toLowerCase().startsWith("https://");
        if (!isSSL) {
            isSSL = urlString.toLowerCase().startsWith("wss://");
        }
        return isSSL;
    }

    private void init(String urlString, int timeOut) {
        try {
            this.isSSL = this.trySSL(urlString);
            this.hostString = urlString;
            int port = 80;
            if (this.hostString.toLowerCase().startsWith("ws")) {
                this.hostString = "http" + this.hostString.substring(2, this.hostString.length());
            }
            if (this.hostString.toLowerCase().startsWith("http")) {
                URL url = new URL(this.hostString);
                this.hostString = url.getHost();
                port = url.getPort();
            }
            if (port == -1 && !this.isSSL) {
                port = 80;
            } else if (port == -1 && this.isSSL) {
                port = 443;
            }
            this.parameters = new HashMap<String, Object>();
            this.socket = new TcpSocket(this.hostString, port == -1 ? 80 : port, timeOut * 1000);
            this.socket.filterChain().add(new HttpClientFilter(this));
            this.socket.messageSplitter(new HttpMessageSplitter());
            if (this.isSSL) {
                try {
                    SSLManager sslManager = new SSLManager("TLS");
                    this.socket.setSSLManager(sslManager);
                }
                catch (NoSuchAlgorithmException e) {
                    Logger.error(e);
                }
            }
            this.socket.syncStart();
            this.httpRequest = new HttpRequest(new Request(), this.charset, this.socket.getSession());
            this.initHeader();
        }
        catch (IOException e) {
            Logger.error("HttpClient init error", e);
        }
    }

    public void initHeader() {
        this.httpRequest.header().put("Host", this.hostString);
        this.httpRequest.header().put("Pragma", "no-collection");
        this.httpRequest.header().put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
        this.httpRequest.header().put("User-Agent", "Voovan Http Client");
        this.httpRequest.header().put("Accept-Encoding", "gzip");
        this.httpRequest.header().put("Connection", "keep-alive");
    }

    protected TcpSocket getSocket() {
        return this.socket;
    }

    public ByteBuffer loadStream() throws IOException {
        TcpSession session = this.socket.getSession();
        ByteBuffer tmpBuffer = ByteBuffer.allocate(this.socket.getReadBufferSize());
        session.enabledMessageSpliter(false);
        int readSize = session.read(tmpBuffer);
        if (session.getAttribute("SocketException") instanceof Exception) {
            ((IoSession)session).close();
            return null;
        }
        if (readSize > 0) {
            return tmpBuffer;
        }
        if (readSize == 0) {
            tmpBuffer.flip();
        } else if (readSize == -1) {
            return null;
        }
        return tmpBuffer;
    }

    public HttpClient setMethod(String method) {
        this.httpRequest.protocol().setMethod(method);
        return this;
    }

    public HttpClient setBodyType(Request.RequestType bodyType) {
        if (!this.httpRequest.header().contain("Content-Type")) {
            if (bodyType == Request.RequestType.BODY_MULTIPART) {
                this.httpRequest.header().put("Content-Type", "multipart/form-data;");
            } else if (bodyType == Request.RequestType.BODY_URLENCODED) {
                this.httpRequest.header().put("Content-Type", "application/x-www-form-urlencoded");
            }
        }
        return this;
    }

    public HttpClient setData(byte[] data) {
        if (data != null) {
            this.httpRequest.body().write(data);
        }
        return this;
    }

    public HttpClient setData(String data) {
        if (data != null) {
            this.httpRequest.body().write(data);
        }
        return this;
    }

    public HttpClient setData(String data, String charset) {
        if (data != null) {
            this.httpRequest.body().write(data, charset);
        }
        return this;
    }

    public Header getHeader() {
        return this.httpRequest.header();
    }

    public HttpClient putHeader(String name, String value) {
        this.httpRequest.header().put(name, value);
        return this;
    }

    public List<Cookie> getCookies() {
        return this.httpRequest.cookies();
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public HttpClient putParameters(String name, String value) {
        this.parameters.put(name, value);
        return this;
    }

    public HttpClient addPart(Part part) {
        this.httpRequest.parts().add(part);
        return this;
    }

    public void uploadFile(String name, File file) {
        this.setBodyType(Request.RequestType.BODY_MULTIPART);
        this.parameters.put(name, file);
    }

    public static String buildQueryString(Map<String, Object> parameters, String charset) {
        String queryString = "";
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                queryStringBuilder.append(parameter.getKey());
                queryStringBuilder.append("=");
                queryStringBuilder.append(URLEncoder.encode(TObject.nullDefault(parameter.getValue(), "").toString(), charset));
                queryStringBuilder.append("&");
            }
            queryString = queryStringBuilder.toString();
            queryString = queryStringBuilder.length() > 0 ? TString.removeSuffix(queryString) : queryString;
        }
        catch (IOException e) {
            Logger.error("HttpClient getQueryString error", e);
        }
        return queryString.isEmpty() ? "" : queryString;
    }

    private String getQueryString() {
        return HttpClient.buildQueryString(this.parameters, this.charset);
    }

    private void buildRequest(String urlString) {
        this.httpRequest.protocol().setPath(urlString.isEmpty() ? "/" : urlString);
        if (this.httpRequest.getBodyType() == Request.RequestType.NORMAL) {
            String queryString = this.getQueryString();
            if (!TString.isNullOrEmpty(queryString)) {
                String requestPath = this.httpRequest.protocol().getPath();
                queryString = requestPath.contains("?") ? "&" + queryString : "?" + queryString;
                this.httpRequest.protocol().setPath(this.httpRequest.protocol().getPath() + queryString);
            }
        } else if (this.httpRequest.getBodyType() == Request.RequestType.BODY_MULTIPART) {
            try {
                for (Map.Entry<String, Object> parameter : this.parameters.entrySet()) {
                    Part part = new Part();
                    part.header().put("name", parameter.getKey());
                    if (parameter.getValue() instanceof String) {
                        part.body().changeToBytes(URLEncoder.encode(parameter.getValue().toString(), this.charset).getBytes(this.charset));
                    } else if (parameter.getValue() instanceof File) {
                        File file = (File)parameter.getValue();
                        part.body().changeToFile(file);
                        part.header().put("filename", file.getName());
                    }
                    this.httpRequest.parts().add(part);
                }
            }
            catch (IOException e) {
                Logger.error("HttpClient buildRequest error", e);
            }
        } else if (this.httpRequest.getBodyType() == Request.RequestType.BODY_URLENCODED) {
            String queryString = this.getQueryString();
            this.httpRequest.body().write(queryString, this.charset);
        }
    }

    public synchronized Response send(String location) throws SendMessageException, ReadMessageException {
        if (this.isWebSocket) {
            throw new SendMessageException("The WebSocket is connect, you can't writeToChannel http request.");
        }
        if (this.httpRequest.protocol().getMethod().equals("POST") && this.httpRequest.parts().size() > 0) {
            this.setBodyType(Request.RequestType.BODY_MULTIPART);
        } else if (this.httpRequest.protocol().getMethod().equals("POST")) {
            this.setBodyType(Request.RequestType.BODY_URLENCODED);
        } else {
            this.setBodyType(Request.RequestType.NORMAL);
        }
        this.buildRequest(TString.isNullOrEmpty(location) ? "/" : location);
        try {
            this.httpRequest.send(this.socket.getSession());
            this.httpRequest.flush();
        }
        catch (IOException e) {
            throw new SendMessageException("HttpClient writeToChannel error", e);
        }
        try {
            Object readObject = this.socket.synchronouRead();
            Response response = null;
            if (readObject instanceof Exception) {
                throw new ReadMessageException((Exception)readObject);
            }
            response = (Response)readObject;
            this.finished(this.httpRequest, response);
            return response;
        }
        catch (ReadMessageException e) {
            if (!this.isWebSocket) {
                throw e;
            }
            return null;
        }
    }

    public synchronized Response send() throws SendMessageException, ReadMessageException {
        return this.send("/");
    }

    public int send(ByteBuffer buffer) throws IOException {
        return this.httpRequest.send(buffer);
    }

    private void finished(Request request, Response response) {
        if (response != null && response.cookies() != null && !response.cookies().isEmpty()) {
            request.cookies().addAll(response.cookies());
        }
        request.body().changeToBytes(new byte[0]);
        this.parameters.clear();
        request.body().clear();
        request.parts().clear();
        request.header().clear();
        this.initHeader();
    }

    private void doWebSocketUpgrade(String location) throws SendMessageException, ReadMessageException {
        TcpSession session = this.socket.getSession();
        session.removeAttribute(HttpSessionParam.TYPE);
        this.httpRequest.header().put("Host", this.hostString);
        this.httpRequest.header().put("Connection", "Upgrade");
        this.httpRequest.header().put("Upgrade", "websocket");
        this.httpRequest.header().put("Pragma", "no-collection");
        this.httpRequest.header().put("Origin", this.urlString);
        this.httpRequest.header().put("Sec-WebSocket-Version", "13");
        this.httpRequest.header().put("Sec-WebSocket-Key", "c1Mm+c0b28erlzCWWYfrIg==");
        this.send(location);
    }

    public void webSocket(String location, WebSocketRouter webSocketRouter) throws SendMessageException, ReadMessageException {
        this.webSocketRouter = webSocketRouter;
        this.doWebSocketUpgrade(location);
        try {
            TEnv.wait(this.socket.getReadTimeout(), () -> this.socket.isOpen());
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
    }

    protected void initWebSocket() {
        this.isWebSocket = true;
        TcpSession session = this.socket.getSession();
        WebSocketSession webSocketSession = new WebSocketSession(this.socket.getSession(), this.webSocketRouter, WebSocketType.CLIENT);
        WebSocketHandler webSocketHandler = new WebSocketHandler(this, webSocketSession, this.webSocketRouter);
        webSocketSession.setWebSocketRouter(this.webSocketRouter);
        this.socket.handler(webSocketHandler);
        session.setAttribute(HttpSessionParam.TYPE, (Object)HttpRequestType.WEBSOCKET);
        Object result = null;
        result = this.webSocketRouter.onOpen(webSocketSession);
        if (result != null) {
            ByteBuffer buffer = null;
            try {
                buffer = (ByteBuffer)this.webSocketRouter.filterEncoder(webSocketSession, result);
                WebSocketFrame webSocketFrame = WebSocketFrame.newInstance(true, WebSocketFrame.Opcode.TEXT, true, buffer);
                this.sendWebSocketData(webSocketFrame);
            }
            catch (WebSocketFilterException e) {
                Logger.error(e);
            }
            catch (SendMessageException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendWebSocketData(WebSocketFrame webSocketFrame) throws SendMessageException {
        this.socket.getSession().syncSend(webSocketFrame);
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public boolean isConnect() {
        if (this.socket != null) {
            return this.socket.isConnected();
        }
        return false;
    }
}

