/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.voovan.db.JdbcOperate;
import org.voovan.db.TranscationType;
import org.voovan.tools.TSQL;
import org.voovan.tools.log.Logger;

public class ResultInfo {
    private ResultSet resultSet;
    private JdbcOperate jdbcOperate;

    public ResultInfo(ResultSet resultSet, JdbcOperate jdbcOperate) {
        this.resultSet = resultSet;
        this.jdbcOperate = jdbcOperate;
    }

    public JdbcOperate getJdbcOperate() {
        return this.jdbcOperate;
    }

    public <T> List<T> getObjectList(Class<T> t) {
        try {
            List<Object> list = TSQL.getAllRowWithObjectList(t, this.resultSet);
            return list;
        }
        catch (ReflectiveOperationException | SQLException | ParseException e) {
            Logger.error("JdbcOperate.getObjectList error", e);
        }
        finally {
            if (this.jdbcOperate.getTranscationType() == TranscationType.NONE) {
                JdbcOperate.closeConnection(this.resultSet);
            } else {
                JdbcOperate.closeResult(this.resultSet);
            }
        }
        return new ArrayList();
    }

    public List<Map<String, Object>> getMapList() {
        try {
            List<Map<String, Object>> list = TSQL.getAllRowWithMapList(this.resultSet);
            return list;
        }
        catch (ReflectiveOperationException | SQLException e) {
            Logger.error("JdbcOperate.getMapList error", e);
        }
        finally {
            if (this.jdbcOperate.getTranscationType() == TranscationType.NONE) {
                JdbcOperate.closeConnection(this.resultSet);
            } else {
                JdbcOperate.closeResult(this.resultSet);
            }
        }
        return new ArrayList<Map<String, Object>>();
    }

    public <T> Object getObject(Class<T> t) {
        try {
            if (this.resultSet.next()) {
                Object object = TSQL.getOneRowWithObject(t, this.resultSet);
                return object;
            }
            Object var2_3 = null;
            return var2_3;
        }
        catch (ReflectiveOperationException | SQLException | ParseException e) {
            Logger.error("JdbcOperate.getObject error", e);
        }
        finally {
            if (this.jdbcOperate.getTranscationType() == TranscationType.NONE) {
                JdbcOperate.closeConnection(this.resultSet);
            } else {
                JdbcOperate.closeResult(this.resultSet);
            }
        }
        return null;
    }

    public Map<String, Object> getMap() {
        try {
            if (this.resultSet.next()) {
                Map<String, Object> map = TSQL.getOneRowWithMap(this.resultSet);
                return map;
            }
            Map<String, Object> map = null;
            return map;
        }
        catch (ReflectiveOperationException | SQLException e) {
            Logger.error("JdbcOperate.getMap error", e);
        }
        finally {
            if (this.jdbcOperate.getTranscationType() == TranscationType.NONE) {
                JdbcOperate.closeConnection(this.resultSet);
            } else {
                JdbcOperate.closeResult(this.resultSet);
            }
        }
        return null;
    }
}

