/*
 * Decompiled with CFR 0.152.
 */
package org.voovan.db;

import java.io.Closeable;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.voovan.db.CallType;
import org.voovan.db.ResultInfo;
import org.voovan.db.TranscationType;
import org.voovan.db.exception.UpdateCountException;
import org.voovan.tools.TObject;
import org.voovan.tools.TSQL;
import org.voovan.tools.json.JSON;
import org.voovan.tools.log.Logger;
import org.voovan.tools.reflect.TReflect;

public class JdbcOperate
implements Closeable {
    private static Map<Long, JdbcOperate> JDBCOPERATE_THREAD_LIST = new ConcurrentHashMap<Long, JdbcOperate>();
    private DataSource dataSource;
    private Connection connection;
    private TranscationType transcationType;
    private Savepoint savepoint = null;
    private Statement statement;
    private ResultSet resultSet;
    private List<JdbcOperate> bindedJdbcOperate = new ArrayList<JdbcOperate>();
    private boolean isTransactionFinished = false;

    public JdbcOperate(DataSource dataSource) {
        this.dataSource = dataSource;
        this.transcationType = TranscationType.NONE;
    }

    public JdbcOperate(DataSource dataSource, boolean isTrancation) {
        this.dataSource = dataSource;
        this.transcationType = isTrancation ? TranscationType.NEST : TranscationType.NONE;
    }

    public JdbcOperate(DataSource dataSource, TranscationType transcationType) {
        this.dataSource = dataSource;
        this.transcationType = transcationType;
    }

    public synchronized boolean addBind(JdbcOperate subJdbcOperate, boolean bothway) {
        if (subJdbcOperate.transcationType == TranscationType.NEST && !this.bindedJdbcOperate.contains(subJdbcOperate)) {
            if (bothway) {
                subJdbcOperate.bindedJdbcOperate.add(this);
            }
            return this.bindedJdbcOperate.add(subJdbcOperate);
        }
        return false;
    }

    public synchronized boolean removeBind(JdbcOperate subJdbcOperate, boolean bothway) {
        if (bothway) {
            subJdbcOperate.bindedJdbcOperate.remove(this);
        }
        return this.bindedJdbcOperate.remove(subJdbcOperate);
    }

    public synchronized Connection getConnection() throws SQLException {
        long threadId = Thread.currentThread().getId();
        if (this.connection == null || this.connection.isClosed()) {
            if (this.transcationType == TranscationType.NEST) {
                if (JDBCOPERATE_THREAD_LIST.containsKey(threadId)) {
                    this.connection = JdbcOperate.JDBCOPERATE_THREAD_LIST.get((Object)Long.valueOf((long)threadId)).connection;
                    this.savepoint = this.connection.setSavepoint();
                } else {
                    this.connection = this.dataSource.getConnection();
                    this.connection.setAutoCommit(false);
                    JDBCOPERATE_THREAD_LIST.put(threadId, this);
                }
            } else if (this.transcationType == TranscationType.ALONE) {
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(false);
            } else if (this.transcationType == TranscationType.NONE) {
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(true);
            }
        }
        return this.connection;
    }

    public TranscationType getTranscationType() {
        return this.transcationType;
    }

    public synchronized void commit(boolean isClose) throws SQLException {
        if (this.connection == null) {
            return;
        }
        for (JdbcOperate bindJdbcOperate : this.bindedJdbcOperate) {
            if (!this.equals(bindJdbcOperate) || bindJdbcOperate.isTransactionFinished) continue;
            bindJdbcOperate.commit(isClose);
        }
        if (!this.connection.isClosed()) {
            this.connection.commit();
            if (isClose) {
                JdbcOperate.closeConnection(this.connection);
            }
        }
        this.isTransactionFinished = true;
    }

    public synchronized void rollback(boolean isClose) throws SQLException {
        if (this.connection == null) {
            return;
        }
        if (this.savepoint != null) {
            this.connection.rollback(this.savepoint);
        } else {
            for (JdbcOperate bindJdbcOperate : this.bindedJdbcOperate) {
                if (!this.equals(bindJdbcOperate) || bindJdbcOperate.isTransactionFinished) continue;
                bindJdbcOperate.rollback(isClose);
            }
            if (!this.connection.isClosed()) {
                this.connection.rollback();
                if (isClose) {
                    JdbcOperate.closeConnection(this.connection);
                }
            }
            this.isTransactionFinished = true;
        }
    }

    public void commit() throws SQLException {
        this.commit(true);
    }

    public void rollback() throws SQLException {
        this.rollback(true);
    }

    private ResultInfo baseQuery(String sqlText, Map<String, Object> mapArg) throws SQLException {
        Connection conn = this.getConnection();
        SQLException exception = null;
        try {
            PreparedStatement preparedStatement = TSQL.createPreparedStatement(conn, sqlText, mapArg);
            this.resultSet = preparedStatement.executeQuery();
            return new ResultInfo(this.resultSet, this);
        }
        catch (SQLException e) {
            JdbcOperate.closeConnection(conn);
            Logger.error("Query execution SQL Error! \n SQL is : \n\t" + sqlText + ": \n\t ", e);
            exception = e;
            if (exception != null) {
                throw exception;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int baseUpdate(String sqlText, Map<String, Object> mapArg) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement preparedStatement = null;
        SQLException exception = null;
        try {
            preparedStatement = TSQL.createPreparedStatement(conn, sqlText, mapArg);
            this.statement = preparedStatement;
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            Logger.error("Update execution SQL Error! \n SQL is :\n\t " + sqlText + "\nError is: \n\t", e);
            exception = e;
        }
        finally {
            if (this.transcationType == TranscationType.NONE) {
                JdbcOperate.closeConnection(preparedStatement);
            } else {
                if (exception != null) {
                    this.rollback();
                }
                JdbcOperate.closeStatement(preparedStatement);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] baseBatch(String[] sqlTexts) throws SQLException {
        Connection conn = this.getConnection();
        Statement statement = null;
        SQLException exception = null;
        try {
            int[] result;
            statement = conn.createStatement();
            for (String sqlText : sqlTexts) {
                if (!Logger.isLogLevel("DEBUG")) continue;
                statement.addBatch(sqlText);
                Logger.fremawork("[SQL_Executed]: " + sqlText);
            }
            int[] nArray = result = statement.executeBatch();
            return nArray;
        }
        catch (SQLException e) {
            Logger.error("Batch execution SQL Error! \n SQL is : \n\t" + JSON.toJSON(sqlTexts) + ":\n\t", e);
            exception = e;
        }
        finally {
            if (this.transcationType == TranscationType.NONE) {
                JdbcOperate.closeConnection(statement);
            } else {
                if (exception != null) {
                    this.rollback();
                }
                JdbcOperate.closeStatement(statement);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return new int[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] baseBatch(String sqlText, List<Map<String, Object>> mapArgs) throws SQLException {
        Connection conn = this.getConnection();
        PreparedStatement preparedStatement = null;
        SQLException exception = null;
        try {
            int[] result;
            List<String> sqlParams = TSQL.getSqlParamNames(sqlText);
            preparedStatement = conn.prepareStatement(TSQL.preparedSql(sqlText));
            if (mapArgs != null) {
                for (Map<String, Object> magArg : mapArgs) {
                    TSQL.setPreparedParams(preparedStatement, sqlParams, magArg);
                    preparedStatement.addBatch();
                }
            }
            if (Logger.isLogLevel("DEBUG")) {
                Logger.fremawork("[SQL_Executed]: " + sqlText);
            }
            this.statement = preparedStatement;
            int[] nArray = result = preparedStatement.executeBatch();
            return nArray;
        }
        catch (SQLException e) {
            Logger.error("Batch execution SQL Error! \n SQL is : \n\t" + sqlText + ":\n\t", e);
            exception = e;
        }
        finally {
            if (this.transcationType == TranscationType.NONE) {
                JdbcOperate.closeConnection(preparedStatement);
            } else {
                if (exception != null) {
                    this.rollback();
                }
                JdbcOperate.closeStatement(preparedStatement);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return new int[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> baseCall(String sqlText, CallType[] callTypes, Map<String, Object> mapArg) throws SQLException {
        Connection conn = this.getConnection();
        CallableStatement callableStatement = null;
        SQLException exception = null;
        try {
            List<Object> objList;
            callableStatement = TSQL.createCallableStatement(conn, sqlText, mapArg, callTypes);
            this.statement = callableStatement;
            callableStatement.executeUpdate();
            List<Object> list = objList = TSQL.getCallableStatementResult(callableStatement);
            return list;
        }
        catch (SQLException e) {
            Logger.error("Query execution SQL Error! \n SQL is : \n\t" + sqlText + ": \n\t ", e);
            exception = e;
        }
        finally {
            if (this.transcationType == TranscationType.NONE) {
                JdbcOperate.closeConnection(callableStatement);
            } else {
                if (exception != null) {
                    this.rollback();
                }
                JdbcOperate.closeStatement(callableStatement);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    public int update(String sqlText) throws SQLException {
        return this.baseUpdate(sqlText, null);
    }

    public int update(String sqlText, Object arg) throws SQLException, ReflectiveOperationException {
        if (TReflect.isBasicType(arg.getClass())) {
            return this.update(sqlText, arg, null);
        }
        Map<String, Object> paramsMap = TReflect.getMapfromObject(arg);
        return this.baseUpdate(sqlText, paramsMap);
    }

    public int update(String sqlText, Map<String, Object> mapArg) throws SQLException {
        return this.baseUpdate(sqlText, mapArg);
    }

    public int update(String sqlText, Object ... args) throws SQLException {
        Map<String, Object> paramsMap = TObject.arrayToMap(args);
        return this.baseUpdate(sqlText, paramsMap);
    }

    public int updateAndCheck(String sqlText, int updateCount) throws SQLException {
        int count = this.update(sqlText);
        if (count != updateCount) {
            throw new UpdateCountException("Update row count error, expect: " + updateCount + "actual: " + count + ".");
        }
        return count;
    }

    public int updateAndCheck(String sqlText, int updateCount, Object arg) throws SQLException, ReflectiveOperationException {
        int count = this.update(sqlText, arg);
        if (count != updateCount) {
            throw new UpdateCountException("Update row count error, expect: " + updateCount + "actual: " + count + ".");
        }
        return count;
    }

    public int updateAndCheck(String sqlText, int updateCount, Map<String, Object> mapArg) throws SQLException {
        int count = this.update(sqlText, mapArg);
        if (count != updateCount) {
            throw new UpdateCountException("Update row count error, expect: " + updateCount + "actual: " + count + ".");
        }
        return count;
    }

    public int updateAndCheck(String sqlText, int updateCount, Object ... args) throws SQLException {
        Map<String, Object> paramsMap = TObject.arrayToMap(args);
        int count = this.update(sqlText, paramsMap);
        if (count != updateCount) {
            throw new UpdateCountException("Update row count error, expect: " + updateCount + "actual: " + count + ".");
        }
        return count;
    }

    public <T> List<T> queryObjectList(String sqlText, Class<T> t) throws SQLException {
        ResultInfo resultInfo = this.baseQuery(sqlText, null);
        if (resultInfo != null) {
            return resultInfo.getObjectList(t);
        }
        return new ArrayList();
    }

    public <T> List<T> queryObjectList(String sqlText, Class<T> t, Object arg) throws SQLException, ReflectiveOperationException {
        if (TReflect.isBasicType(arg.getClass())) {
            return this.queryObjectList(sqlText, t, arg, null);
        }
        Map<String, Object> paramsMap = TReflect.getMapfromObject(arg);
        ResultInfo resultInfo = this.baseQuery(sqlText, paramsMap);
        if (resultInfo != null) {
            return resultInfo.getObjectList(t);
        }
        return new ArrayList();
    }

    public <T> List<T> queryObjectList(String sqlText, Class<T> t, Map<String, Object> mapArg) throws SQLException {
        ResultInfo resultInfo = this.baseQuery(sqlText, mapArg);
        if (resultInfo != null) {
            return resultInfo.getObjectList(t);
        }
        return new ArrayList();
    }

    public <T> List<T> queryObjectList(String sqlText, Class<T> t, Object ... args) throws SQLException {
        Map<String, Object> paramsMap = TObject.arrayToMap(args);
        ResultInfo resultInfo = this.baseQuery(sqlText, paramsMap);
        if (resultInfo != null) {
            return resultInfo.getObjectList(t);
        }
        return new ArrayList();
    }

    public List<Map<String, Object>> queryMapList(String sqlText) throws SQLException {
        ResultInfo resultInfo = this.baseQuery(sqlText, null);
        if (resultInfo != null) {
            return resultInfo.getMapList();
        }
        return new ArrayList<Map<String, Object>>();
    }

    public List<Map<String, Object>> queryMapList(String sqlText, Object arg) throws SQLException, ReflectiveOperationException {
        if (TReflect.isBasicType(arg.getClass())) {
            return this.queryMapList(sqlText, arg, null);
        }
        Map<String, Object> paramsMap = TReflect.getMapfromObject(arg);
        ResultInfo resultInfo = this.baseQuery(sqlText, paramsMap);
        if (resultInfo != null) {
            return resultInfo.getMapList();
        }
        return new ArrayList<Map<String, Object>>();
    }

    public List<Map<String, Object>> queryMapList(String sqlText, Map<String, Object> mapArg) throws SQLException {
        ResultInfo resultInfo = this.baseQuery(sqlText, mapArg);
        if (resultInfo != null) {
            return resultInfo.getMapList();
        }
        return new ArrayList<Map<String, Object>>();
    }

    public List<Map<String, Object>> queryMapList(String sqlText, Object ... args) throws SQLException {
        Map<String, Object> paramsMap = TObject.arrayToMap(args);
        ResultInfo resultInfo = this.baseQuery(sqlText, paramsMap);
        if (resultInfo != null) {
            return resultInfo.getMapList();
        }
        return new ArrayList<Map<String, Object>>();
    }

    public <T> T queryObject(String sqlText, Class<T> t) throws SQLException {
        ResultInfo resultInfo = this.baseQuery(sqlText, null);
        if (resultInfo != null) {
            return (T)resultInfo.getObject(t);
        }
        return null;
    }

    public <T> T queryObject(String sqlText, Class<T> t, Object arg) throws SQLException, ReflectiveOperationException, ParseException {
        if (TReflect.isBasicType(arg.getClass())) {
            return this.queryObject(sqlText, t, arg, null);
        }
        Map<String, Object> paramsMap = TReflect.getMapfromObject(arg);
        ResultInfo resultInfo = this.baseQuery(sqlText, paramsMap);
        if (resultInfo != null) {
            return (T)resultInfo.getObject(t);
        }
        return null;
    }

    public <T> T queryObject(String sqlText, Class<T> t, Map<String, Object> mapArg) throws SQLException {
        ResultInfo resultInfo = this.baseQuery(sqlText, mapArg);
        if (resultInfo != null) {
            return (T)resultInfo.getObject(t);
        }
        return null;
    }

    public <T> T queryObject(String sqlText, Class<T> t, Object ... args) throws SQLException {
        Map<String, Object> paramsMap = TObject.arrayToMap(args);
        ResultInfo resultInfo = this.baseQuery(sqlText, paramsMap);
        if (resultInfo != null) {
            return (T)resultInfo.getObject(t);
        }
        return null;
    }

    public Map<String, Object> queryMap(String sqlText) throws SQLException {
        ResultInfo resultInfo = this.baseQuery(sqlText, null);
        if (resultInfo != null) {
            return resultInfo.getMap();
        }
        return null;
    }

    public Map<String, Object> queryMap(String sqlText, Object arg) throws SQLException, ReflectiveOperationException {
        if (TReflect.isBasicType(arg.getClass())) {
            return this.queryMap(sqlText, arg, null);
        }
        Map<String, Object> paramsMap = TReflect.getMapfromObject(arg);
        ResultInfo resultInfo = this.baseQuery(sqlText, paramsMap);
        if (resultInfo != null) {
            return resultInfo.getMap();
        }
        return null;
    }

    public Map<String, Object> queryMap(String sqlText, Map<String, Object> mapArg) throws SQLException {
        ResultInfo resultInfo = this.baseQuery(sqlText, mapArg);
        if (resultInfo != null) {
            return resultInfo.getMap();
        }
        return null;
    }

    public Map<String, Object> queryMap(String sqlText, Object ... args) throws SQLException {
        Map<String, Object> paramsMap = TObject.arrayToMap(args);
        ResultInfo resultInfo = this.baseQuery(sqlText, paramsMap);
        if (resultInfo != null) {
            return resultInfo.getMap();
        }
        return null;
    }

    public int[] batchObject(String sqlText, List<?> objects) throws SQLException, ReflectiveOperationException {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Object object : objects) {
            mapList.add(TReflect.getMapfromObject(object));
        }
        return this.baseBatch(sqlText, mapList);
    }

    public int[] batchMap(String sqlText, List<Map<String, Object>> maps) throws SQLException {
        return this.baseBatch(sqlText, maps);
    }

    public int[] batch(String[] sqlTexts) throws SQLException, ReflectiveOperationException {
        return this.baseBatch(sqlTexts);
    }

    public List<Object> call(String sqlText) throws SQLException {
        return this.baseCall(sqlText, null, null);
    }

    public List<Object> call(String sqlText, CallType[] callTypes, Map<String, Object> maps) throws SQLException {
        return this.baseCall(sqlText, callTypes, maps);
    }

    public List<Object> call(String sqlText, CallType[] callTypes, Object arg) throws SQLException, ReflectiveOperationException {
        if (TReflect.isBasicType(arg.getClass())) {
            return this.call(sqlText, callTypes, arg, null);
        }
        Map<String, Object> paramsMap = TReflect.getMapfromObject(arg);
        return this.baseCall(sqlText, callTypes, paramsMap);
    }

    public List<Object> call(String sqlText, CallType[] callTypes, Object ... args) throws SQLException {
        Map<String, Object> paramsMap = TObject.arrayToMap(args);
        return this.baseCall(sqlText, callTypes, paramsMap);
    }

    protected static void closeConnection(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                Statement statement = resultSet.getStatement();
                resultSet.close();
                JdbcOperate.closeConnection(statement);
            }
        }
        catch (SQLException e) {
            Logger.error(e);
        }
    }

    protected static void closeConnection(Statement statement) {
        try {
            if (statement != null) {
                Connection connection = statement.getConnection();
                statement.close();
                JdbcOperate.closeConnection(connection);
            }
        }
        catch (SQLException e) {
            Logger.error(e);
        }
    }

    private static void closeConnection(Connection connection) {
        try {
            if (connection != null) {
                JDBCOPERATE_THREAD_LIST.remove(Thread.currentThread().getId());
                connection.close();
            }
        }
        catch (SQLException e) {
            Logger.error(e);
        }
    }

    protected static void closeResult(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                Statement statement = resultSet.getStatement();
                resultSet.close();
                JdbcOperate.closeStatement(statement);
            }
        }
        catch (SQLException e) {
            Logger.error(e);
        }
    }

    protected static void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            Logger.error(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                JdbcOperate.closeConnection(this.resultSet);
            } else if (this.statement != null && !this.statement.isClosed()) {
                JdbcOperate.closeConnection(this.statement);
            } else {
                JdbcOperate.closeConnection(this.connection);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

