/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class MinIOContainer
extends GenericContainer<MinIOContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"minio/minio");
    private static final int MINIO_S3_PORT = 9000;
    private static final int MINIO_UI_PORT = 9001;
    private static final String DEFAULT_USER = "minioadmin";
    private static final String DEFAULT_PASSWORD = "minioadmin";
    private String userName;
    private String password;

    public MinIOContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public MinIOContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
    }

    public MinIOContainer withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public MinIOContainer withPassword(String password) {
        this.password = password;
        return this;
    }

    public void configure() {
        this.withExposedPorts(new Integer[]{9000, 9001});
        if (this.userName != null) {
            this.addEnv("MINIO_ROOT_USER", this.userName);
        } else {
            this.userName = "minioadmin";
        }
        if (this.password != null) {
            this.addEnv("MINIO_ROOT_PASSWORD", this.password);
        } else {
            this.password = "minioadmin";
        }
        this.withCommand(new String[]{"server", "--console-address", ":9001", "/data"});
        this.waitingFor(Wait.forLogMessage((String)".*Status:         1 Online, 0 Offline..*", (int)1).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS)));
    }

    public String getS3URL() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(9000));
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }
}

