/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.reflector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.test4j.exception.NoSuchFieldRuntimeException;
import org.test4j.tools.commons.ArrayHelper;
import org.test4j.tools.commons.ClazzHelper;
import org.test4j.tools.commons.ListHelper;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.reflector.FieldAccessor;
import org.test4j.tools.reflector.MethodAccessor;

public class PropertyAccessor {
    public static final PropertyAccessor instance = new PropertyAccessor();

    private PropertyAccessor() {
    }

    public Object value(Object target, String ognl) {
        return this.value(target, ognl, true);
    }

    public Object value(Object object, String ognl, boolean throwNoProperty) {
        String[] expressions = ognl.split("\\.");
        try {
            Object target = object;
            String key = "";
            for (String prop : expressions) {
                if (target == null && !throwNoProperty) {
                    return null;
                }
                if (target instanceof Map) {
                    Map map = (Map)target;
                    String string = key = key.equals("") ? prop : key + "." + prop;
                    if (!map.containsKey(key)) continue;
                    target = map.get(key);
                    key = "";
                    continue;
                }
                target = PropertyAccessor.valueOf(target, prop);
            }
            if (!key.equals("")) {
                throw new NoSuchFieldRuntimeException();
            }
            return target;
        }
        catch (NoSuchFieldRuntimeException e) {
            if (throwNoProperty) {
                String className = object == null ? "null" : object.getClass().getName();
                throw new NoSuchFieldRuntimeException("can't find property[" + ognl + "] in object[" + className + "]", e);
            }
            return object;
        }
    }

    public List valueList(Object array, String ognl, boolean throwNoProperty) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (ArrayHelper.isCollOrArray(array)) {
            List list = ListHelper.toList(array);
            for (Object target : list) {
                Object value = this.value(target, ognl, throwNoProperty);
                result.add(value);
            }
        } else {
            Object value = this.value(array, ognl, throwNoProperty);
            if (ArrayHelper.isCollOrArray(value)) {
                result.addAll(ListHelper.toList(value));
            } else {
                result.add(value);
            }
        }
        return result;
    }

    public List valueList(Object object, String property) {
        return this.valueList(object, property, false);
    }

    public List values(Object object, String[] ognlList, boolean throwException) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String ognl : ognlList) {
            Object value = this.value(object, ognl, throwException);
            list.add(value);
        }
        return list;
    }

    public Object[][] valueList(Object arr, String[] ognlList) {
        if (ArrayHelper.isCollOrArray(arr)) {
            List coll = ListHelper.toList(arr);
            ArrayList<Object[]> values = new ArrayList<Object[]>();
            for (Object o : coll) {
                Object[] props = this.values(o, ognlList, false).toArray();
                values.add(props);
            }
            return (Object[][])values.toArray((T[])new Object[0][0]);
        }
        Object[] objects = this.values(arr, ognlList, false).toArray();
        return new Object[][]{objects};
    }

    public List<List> valueList(List list, String[] ognlList, boolean throwNoProperty) {
        ArrayList<List> result = new ArrayList<List>();
        for (Object target : list) {
            ArrayList<Object> items = new ArrayList<Object>();
            if (ArrayHelper.isCollOrArray(target) && !throwNoProperty) {
                result.add(ListHelper.toList(target));
                continue;
            }
            for (String ognl : ognlList) {
                Object value = this.value(target, ognl, throwNoProperty);
                items.add(value);
            }
            result.add(items);
        }
        return result;
    }

    private static Object valueOf(Object o, String prop) {
        if (o == null) {
            throw new RuntimeException("can't get the property value from a null object.");
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            if (map.containsKey(prop)) {
                return map.get(prop);
            }
            throw new NoSuchFieldRuntimeException("no key[" + prop + "] value in map.");
        }
        Object target = ClazzHelper.getProxiedObject(o);
        try {
            String method = StringHelper.camel("get", prop);
            return MethodAccessor.invoke(target, method, new Object[0]);
        }
        catch (Throwable e) {
            try {
                String method = StringHelper.camel("is", prop);
                Object result = MethodAccessor.invoke(target, method, new Object[0]);
                if (result instanceof Boolean) {
                    return result;
                }
                throw new RuntimeException();
            }
            catch (Throwable e1) {
                return FieldAccessor.getValue(target, prop);
            }
        }
    }
}

