/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.reflector;

import java.lang.reflect.Method;
import org.test4j.Logger;
import org.test4j.tools.commons.ClazzHelper;
import org.test4j.tools.reflector.MethodAccessor;

public class DisplayNameFinder {
    static String DISPLAY_NAME = "org.junit.jupiter.api.DisplayName";
    static DisplayNameMethod displayNameMethod = null;

    public static String displayName(Method method) {
        Object o;
        if (method == null) {
            return null;
        }
        if (displayNameMethod != null && (o = method.getDeclaredAnnotation(DisplayNameFinder.displayNameMethod.klass)) != null) {
            return (String)MethodAccessor.method(DisplayNameFinder.displayNameMethod.method).invoke(o, new Object[0]);
        }
        return method.getName();
    }

    private static void displayName() {
        try {
            if (ClazzHelper.isClassAvailable(DISPLAY_NAME)) {
                Class clazz = ClazzHelper.getClazz(DISPLAY_NAME);
                displayNameMethod = new DisplayNameMethod(clazz);
            }
        }
        catch (Exception e) {
            Logger.warn((Object)e.getMessage(), (Throwable[])new Throwable[0]);
        }
    }

    static {
        DisplayNameFinder.displayName();
    }

    static class DisplayNameMethod {
        Class klass;
        Method method;

        public DisplayNameMethod(Class klass) throws Exception {
            this.klass = klass;
            this.method = this.klass.getMethod("value", new Class[0]);
        }
    }
}

