/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.json.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.test4j.tools.commons.StringHelper;
import org.test4j.tools.json.interal.JSONInterface;

public class GsonImpl
implements JSONInterface {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    private static final Gson gson_pretty = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).setDateFormat("yyyy-MM-dd HH:mm:ss").create();

    @Override
    public String toJSON(Object object, boolean isFormat) {
        if (isFormat) {
            return gson_pretty.toJson(object);
        }
        return gson.toJson(object);
    }

    @Override
    public <T> T toObject(String json, Type klass) {
        return (T)gson.fromJson(json, klass);
    }

    @Override
    public <T> T toObject(String json) {
        if (StringHelper.isBlank(json)) {
            return null;
        }
        String text = json.trim();
        if (text.startsWith("[") && text.endsWith("]")) {
            return (T)gson.fromJson(text, HashMap.class);
        }
        if (text.startsWith("{") && text.endsWith("}")) {
            return (T)gson.fromJson(text, ArrayList.class);
        }
        return (T)json;
    }

    @Override
    public <T> List<T> toList(String json, Class<T> klass) {
        return (List)gson.fromJson(json, TypeToken.getParameterized(ArrayList.class, (Type[])new Type[]{klass}).getType());
    }

    @Override
    public <T> List<T> toList(String json) {
        return (List)gson.fromJson(json, ArrayList.class);
    }
}

