/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.generic;

import java.lang.reflect.TypeVariable;

public class GenericTypeKey {
    private final String className;
    private final String simpleClassName;
    private final String genericName;

    public GenericTypeKey(Class aClass, String genericName) {
        this.className = aClass.getName();
        this.simpleClassName = aClass.getSimpleName();
        this.genericName = genericName;
    }

    public GenericTypeKey(String aClass, String genericName) {
        this.className = aClass;
        this.simpleClassName = aClass.substring(aClass.lastIndexOf(46) + 1);
        this.genericName = genericName;
    }

    public GenericTypeKey(TypeVariable typeVariable) {
        this((Class)typeVariable.getGenericDeclaration(), typeVariable.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.genericName == null ? 0 : this.genericName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericTypeKey other = (GenericTypeKey)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.genericName == null) {
            return other.genericName == null;
        }
        return this.genericName.equals(other.genericName);
    }

    public String toString() {
        return this.simpleClassName + "<" + this.genericName + ">";
    }
}

