/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.generic;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.test4j.tools.generic.GenericTypeMap;

public class GenericTypeFinder {
    public static GenericTypeMap findGenericTypes(Type type) {
        GenericTypeMap map = new GenericTypeMap();
        GenericTypeFinder.fillInterfaceTypes(type, map);
        return map;
    }

    private static void fillInterfaceTypes(Type type, GenericTypeMap typeMap) {
        while (type != null && !Object.class.equals((Object)type)) {
            Type[] interfaces;
            Class raw = GenericTypeFinder.fillTypeGenericType(type, typeMap);
            for (Type _interface : interfaces = raw.getGenericInterfaces()) {
                GenericTypeFinder.fillInterfaceTypes(_interface, typeMap);
            }
            type = raw.getGenericSuperclass();
        }
    }

    private static Type[] getTypeArgs(Type type) {
        if (type instanceof Class) {
            return new Type[0];
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[0];
    }

    private static Class getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return Object.class;
    }

    private static Class fillTypeGenericType(Type type, GenericTypeMap map) {
        Class raw = GenericTypeFinder.getRawType(type);
        Type[] args = GenericTypeFinder.getTypeArgs(type);
        TypeVariable<Class<T>>[] vars = raw.getTypeParameters();
        int index = 0;
        for (Type arg : args) {
            if (arg instanceof TypeVariable) {
                map.putGeneric(vars[index], (TypeVariable)arg);
            } else {
                map.putType(vars[index], arg);
            }
            ++index;
        }
        return raw;
    }
}

