/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.StringTokenizer;
import org.test4j.tools.IKit;

public class StringHelper {
    public static final String DOUBLE_QUOTATION = "\"";
    private static final boolean[] Space_Chars = new boolean[256];

    public static boolean isBlank(String in) {
        if (in == null) {
            return true;
        }
        return in.trim().isEmpty();
    }

    public static boolean notBlank(String in) {
        return !StringHelper.isBlank(in);
    }

    public static String trim(String source) {
        if (source == null) {
            return null;
        }
        return source.trim();
    }

    public static String camel(String name) {
        if (StringHelper.isBlank(name)) {
            return "";
        }
        StringBuilder b = new StringBuilder(name.length());
        StringTokenizer t = new StringTokenizer(name);
        b.append(t.nextToken());
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            b.append(token.substring(0, 1).toUpperCase());
            b.append(token.substring(1));
        }
        return b.toString();
    }

    public static String camel(String name, String ... strings) {
        StringBuilder b = new StringBuilder(name);
        for (String s : strings) {
            b.append(" ");
            b.append(s);
        }
        return StringHelper.camel(b.toString());
    }

    public static String native2ascii(String nativeStr) {
        StringBuilder ret = new StringBuilder();
        if (nativeStr == null) {
            return null;
        }
        int maxLoop = nativeStr.length();
        for (int i = 0; i < maxLoop; ++i) {
            char character = nativeStr.charAt(i);
            int n127 = 127;
            int n4 = 4;
            if (character <= '\u007f') {
                ret.append(character);
                continue;
            }
            ret.append("\\u");
            String hexStr = Integer.toHexString(character);
            int zeroCount = 4 - hexStr.length();
            for (int j = 0; j < zeroCount; ++j) {
                ret.append('0');
            }
            ret.append(hexStr);
        }
        return ret.toString();
    }

    public static String ascii2native(String asciiStr) {
        if (asciiStr == null) {
            return null;
        }
        StringBuilder retBuf = new StringBuilder();
        int maxLoop = asciiStr.length();
        for (int i = 0; i < maxLoop; ++i) {
            if (asciiStr.charAt(i) == '\\') {
                int n5 = 5;
                int n6 = 6;
                int n16 = 16;
                if (i < maxLoop - 5 && (asciiStr.charAt(i + 1) == 'u' || asciiStr.charAt(i + 1) == 'U')) {
                    try {
                        retBuf.append((char)Integer.parseInt(asciiStr.substring(i + 2, i + 6), 16));
                        i += 5;
                    }
                    catch (NumberFormatException e) {
                        retBuf.append(asciiStr.charAt(i));
                    }
                    continue;
                }
                retBuf.append(asciiStr.charAt(i));
                continue;
            }
            retBuf.append(asciiStr.charAt(i));
        }
        return retBuf.toString();
    }

    public static String deleteWhitespace(String str) {
        if (StringHelper.isEmpty(str)) {
            return str;
        }
        int sz = str.length();
        char[] chs = new char[sz];
        int count = 0;
        for (int i = 0; i < sz; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            chs[count++] = str.charAt(i);
        }
        if (count == sz) {
            return str;
        }
        return new String(chs, 0, count);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String ignoreWhiteSpace(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static boolean isSpace(char ch) {
        return ch <= '\u00ff' && Space_Chars[ch];
    }

    public static String toString(Throwable e) {
        return StringHelper.toString(e, null);
    }

    public static String toString(Throwable e, List<String> filters) {
        if (e == null) {
            return "<error is null>";
        }
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        String tracer = w.toString();
        if (filters != null) {
            for (String regex : filters) {
                tracer = tracer.replaceAll(regex, "");
            }
        }
        return tracer;
    }

    public static String removeBreakingWhiteSpace(String original) {
        StringTokenizer whiteSpaceStripper = new StringTokenizer(original);
        StringBuilder builder = new StringBuilder();
        while (whiteSpaceStripper.hasMoreTokens()) {
            builder.append(whiteSpaceStripper.nextToken());
            builder.append(" ");
        }
        return builder.toString();
    }

    public static String join(String start, String split, String[] strings, String end) {
        return start + String.join((CharSequence)split, strings) + end;
    }

    public static String toJsonString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number || value instanceof String) {
            return String.valueOf(value);
        }
        String text = IKit.json.toJSON(value, false);
        if (text.length() > 2 && text.startsWith(DOUBLE_QUOTATION) && text.endsWith(DOUBLE_QUOTATION)) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    static {
        StringHelper.Space_Chars[32] = true;
        StringHelper.Space_Chars[10] = true;
        StringHelper.Space_Chars[13] = true;
        StringHelper.Space_Chars[9] = true;
        StringHelper.Space_Chars[12] = true;
        StringHelper.Space_Chars[8] = true;
    }
}

