/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

public abstract class StrMatcher {
    public static StrMatcher stringMatcher(String str) {
        if (str == null || str.length() == 0) {
            return NoMatcher.NONE_MATCHER;
        }
        return new StringMatcher(str);
    }

    protected StrMatcher() {
    }

    public abstract int isMatch(char[] var1, int var2, int var3);

    static final class NoMatcher
    extends StrMatcher {
        static final StrMatcher NONE_MATCHER = new NoMatcher();

        NoMatcher() {
        }

        @Override
        public int isMatch(char[] buffer, int pos, int bufferEnd) {
            return 0;
        }
    }

    static final class StringMatcher
    extends StrMatcher {
        private final char[] chars;

        StringMatcher(String str) {
            this.chars = str.toCharArray();
        }

        @Override
        public int isMatch(char[] buffer, int pos, int bufferEnd) {
            int len = this.chars.length;
            if (pos + len > bufferEnd) {
                return 0;
            }
            int i = 0;
            while (i < this.chars.length) {
                if (this.chars[i] != buffer[pos]) {
                    return 0;
                }
                ++i;
                ++pos;
            }
            return len;
        }
    }
}

