/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.test4j.tools.commons.ListHelper;

public class PrimitiveHelper {
    private static final Map<Class, Object> primitiveDefaultValue = new HashMap<Class, Object>();
    private static final Map<Class, Class> couples;
    private static final Set<Class<?>> primitiveBoxed;

    public static boolean isPrimitiveTypeEquals(Class expected, Class actual) {
        Class _expected = expected;
        if (couples.containsKey(expected)) {
            _expected = couples.get(expected);
        }
        Class _actual = actual;
        if (couples.containsKey(actual)) {
            _actual = couples.get(actual);
        }
        return _expected == _actual;
    }

    public static boolean doesEqual(Number num_1, Number num_2) {
        if (num_1 == null) {
            return num_2 == null;
        }
        if (num_2 == null) {
            return false;
        }
        if (PrimitiveHelper.canLongNumber(num_1) && PrimitiveHelper.canLongNumber(num_2)) {
            long l2;
            long l1 = num_1.longValue();
            return l1 == (l2 = num_2.longValue());
        }
        if (PrimitiveHelper.canDoubleNumber(num_1) && PrimitiveHelper.canDoubleNumber(num_2)) {
            double d2;
            double d1 = num_1.doubleValue();
            return d1 == (d2 = num_2.doubleValue());
        }
        return num_1.equals(num_2);
    }

    private static boolean canLongNumber(Number number) {
        return number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof BigInteger;
    }

    private static boolean canDoubleNumber(Number number) {
        return number instanceof Double || number instanceof Float || number instanceof BigDecimal;
    }

    public static boolean isPrimitiveTypeOrBoxed(Class type) {
        return type.isPrimitive() || primitiveBoxed.contains(type);
    }

    public static Object getPrimitiveDefaultValue(Class aClass) {
        return primitiveDefaultValue.getOrDefault(aClass, null);
    }

    static {
        primitiveDefaultValue.put(String.class, "");
        primitiveDefaultValue.put(Integer.class, 0);
        primitiveDefaultValue.put(Short.class, (short)0);
        primitiveDefaultValue.put(Long.class, 0L);
        primitiveDefaultValue.put(Byte.class, (byte)0);
        primitiveDefaultValue.put(Float.class, Float.valueOf(0.0f));
        primitiveDefaultValue.put(Double.class, 0.0);
        primitiveDefaultValue.put(Character.class, Character.valueOf('\u0000'));
        primitiveDefaultValue.put(Boolean.class, false);
        primitiveDefaultValue.put(Integer.TYPE, 0);
        primitiveDefaultValue.put(Short.TYPE, 0);
        primitiveDefaultValue.put(Long.TYPE, 0);
        primitiveDefaultValue.put(Byte.TYPE, 0);
        primitiveDefaultValue.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaultValue.put(Double.TYPE, 0.0);
        primitiveDefaultValue.put(Character.TYPE, Character.valueOf('\u0000'));
        primitiveDefaultValue.put(Boolean.TYPE, false);
        couples = new HashMap<Class, Class>();
        couples.put(Integer.class, Integer.TYPE);
        couples.put(Short.class, Short.TYPE);
        couples.put(Long.class, Long.TYPE);
        couples.put(Byte.class, Byte.TYPE);
        couples.put(Float.class, Float.TYPE);
        couples.put(Double.class, Double.TYPE);
        couples.put(Character.class, Character.TYPE);
        couples.put(Boolean.class, Boolean.TYPE);
        primitiveBoxed = new HashSet(ListHelper.toList(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class));
    }
}

