/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.tools.commons;

import g_objenesis.org.objenesis.ObjenesisHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.framework.Advised;
import org.test4j.Logger;
import org.test4j.exception.NewInstanceException;
import org.test4j.tools.IKit;
import org.test4j.tools.commons.IOUtils;
import org.test4j.tools.reflector.ConstructorArgsGenerator;

public class ClazzHelper {
    private static final Map<String, Boolean> clazzAvailableCache = new HashMap<String, Boolean>();
    private static final String Proxy_Type_Pattern = ".*\\$[Pp]roxy\\d+.*";

    public static boolean isClassAvailable(String className) {
        Boolean isAvailable = clazzAvailableCache.get(className);
        if (isAvailable != null) {
            return isAvailable;
        }
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            clazzAvailableCache.put(className, true);
            return true;
        }
        catch (ClassNotFoundException e) {
            clazzAvailableCache.put(className, false);
            return false;
        }
    }

    public static <T> Class<T> getClazz(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not load class with name " + className, t);
        }
    }

    public static String getPackFromClassName(String clazzName) {
        int index = clazzName.lastIndexOf(".");
        String pack = "";
        if (index > 0) {
            pack = clazzName.substring(0, index);
        }
        return pack;
    }

    public static String getPathFromPath(String clazzName) {
        String pack = ClazzHelper.getPackFromClassName(clazzName);
        return pack.replace(".", "/");
    }

    public static String getPathFromPath(Class clazz) {
        if (clazz == null) {
            return "";
        }
        return ClazzHelper.getPathFromPath(clazz.getName());
    }

    public static <T> T createInstanceOfType(String className) {
        try {
            Class<?> type = Class.forName(className);
            return (T)ClazzHelper.newInstance(type);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Class " + className + " is not of expected type.", e);
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Unable to load class " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class " + className + " not found", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error while instantiating class " + className, e);
        }
    }

    public static boolean isAssignable(Type fromType, Type toType) {
        if (fromType instanceof Class && toType instanceof Class) {
            Class fromClass = (Class)fromType;
            Class toClass = (Class)toType;
            if (Boolean.TYPE.equals(fromClass) && Boolean.class.isAssignableFrom(toClass) || Boolean.TYPE.equals(toClass) && Boolean.class.isAssignableFrom(fromClass)) {
                return true;
            }
            if (Character.TYPE.equals(fromClass) && Character.class.isAssignableFrom(toClass) || Character.TYPE.equals(toClass) && Character.class.isAssignableFrom(fromClass)) {
                return true;
            }
            if (Integer.TYPE.equals(fromClass) && Integer.class.isAssignableFrom(toClass) || Integer.TYPE.equals(toClass) && Integer.class.isAssignableFrom(fromClass)) {
                return true;
            }
            if (Long.TYPE.equals(fromClass) && Long.class.isAssignableFrom(toClass) || Long.TYPE.equals(toClass) && Long.class.isAssignableFrom(fromClass)) {
                return true;
            }
            if (Float.TYPE.equals(fromClass) && Float.class.isAssignableFrom(toClass) || Float.TYPE.equals(toClass) && Float.class.isAssignableFrom(fromClass)) {
                return true;
            }
            if (Double.TYPE.equals(fromClass) && Double.class.isAssignableFrom(toClass) || Double.TYPE.equals(toClass) && Double.class.isAssignableFrom(fromClass)) {
                return true;
            }
            return toClass.isAssignableFrom(fromClass);
        }
        if (toType.equals(fromType)) {
            return true;
        }
        if (toType instanceof ParameterizedType && fromType instanceof ParameterizedType) {
            return ClazzHelper.isAssignable((ParameterizedType)toType, (ParameterizedType)fromType);
        }
        if (toType instanceof WildcardType) {
            return ClazzHelper.isAssignable((WildcardType)toType, fromType);
        }
        return false;
    }

    private static boolean isAssignable(ParameterizedType lhsType, ParameterizedType rhsType) {
        Type[] rhsTypeArguments;
        if (lhsType.equals(rhsType)) {
            return true;
        }
        Type[] lhsTypeArguments = lhsType.getActualTypeArguments();
        if (lhsTypeArguments.length != (rhsTypeArguments = rhsType.getActualTypeArguments()).length) {
            return false;
        }
        int size = lhsTypeArguments.length;
        for (int i = 0; i < size; ++i) {
            Type lhsArg = lhsTypeArguments[i];
            Type rhsArg = rhsTypeArguments[i];
            if (lhsArg.equals(rhsArg) || lhsArg instanceof WildcardType && ClazzHelper.isAssignable((WildcardType)lhsArg, rhsArg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(WildcardType lhsType, Type rhsType) {
        int i;
        Type[] upperBounds = lhsType.getUpperBounds();
        Type[] lowerBounds = lhsType.getLowerBounds();
        int size = upperBounds.length;
        for (i = 0; i < size; ++i) {
            if (ClazzHelper.isAssignable(upperBounds[i], rhsType)) continue;
            return false;
        }
        size = lowerBounds.length;
        for (i = 0; i < size; ++i) {
            if (ClazzHelper.isAssignable(rhsType, lowerBounds[i])) continue;
            return false;
        }
        return true;
    }

    public static <T extends Enum<?>> T getEnumValue(Class<T> enumClass, String enumValueName) {
        Enum[] enumValues;
        for (Enum enumValue : enumValues = (Enum[])enumClass.getEnumConstants()) {
            if (!enumValueName.equalsIgnoreCase(enumValue.name())) continue;
            return (T)enumValue;
        }
        throw new RuntimeException("Unable to find a enum value in enum: " + enumClass + ", with value name: " + enumValueName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getBytes(Class clazz) {
        String name = clazz.getName().replace('.', '/') + ".class";
        try (InputStream iStream = clazz.getClassLoader().getResourceAsStream(name);){
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            assert (iStream != null);
            IOUtils.copy(iStream, (OutputStream)oStream);
            byte[] byArray = oStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> aClass) {
        if (aClass.isMemberClass() && !Modifier.isStatic(aClass.getModifiers())) {
            throw new NewInstanceException("Creation of an instance of a non-static inner class is not possible using reflection. The type " + aClass.getSimpleName() + " is only known in the context of an instance of the enclosing class " + aClass.getEnclosingClass().getSimpleName() + ". Declare the inner class as static to make construction possible.");
        }
        try {
            return ClazzHelper.innerNewInstance(aClass);
        }
        catch (NewInstanceException ne) {
            throw ne;
        }
        catch (Throwable e) {
            throw new NewInstanceException(e);
        }
    }

    private static <T> T innerNewInstance(Class<T> aClass) {
        if (aClass.isInterface()) {
            throw new RuntimeException("create a fake implementation class for interface:" + aClass.getName());
        }
        int modifiers = aClass.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            throw new RuntimeException("not support abstract class!");
        }
        try {
            Constructor<T> constructor = aClass.getDeclaredConstructor(new Class[0]);
            boolean isAccessor = constructor.isAccessible();
            constructor.setAccessible(true);
            T o = constructor.newInstance(new Object[0]);
            constructor.setAccessible(isAccessor);
            return o;
        }
        catch (Throwable e) {
            return (T)ObjenesisHelper.newInstance(aClass);
        }
    }

    public static <T> T newInstance(Class<T> aClass, ConstructorArgsGenerator argGenerator) {
        Constructor<Object> constructor;
        try {
            constructor = aClass.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            constructor = aClass.getDeclaredConstructors()[0];
        }
        if (constructor == null) {
            constructor = aClass.getConstructors()[0];
        }
        try {
            Object[] args = argGenerator.generate(constructor);
            boolean isAccessor = constructor.isAccessible();
            constructor.setAccessible(true);
            Object o = constructor.newInstance(args);
            constructor.setAccessible(isAccessor);
            return (T)o;
        }
        catch (Exception e) {
            Logger.warn((Object)("new instance[" + aClass.getName() + "] error."), (Throwable[])new Throwable[]{e});
            return (T)ObjenesisHelper.newInstance(aClass);
        }
    }

    public static List<Field> getAllFields(Class clazz, Collection<String> filters, boolean includeStatic, boolean includeFinal, boolean includeTransient) {
        ArrayList<Field> jsonFields = new ArrayList<Field>();
        List<Field> fields = IKit.reflector.getAllFields(clazz);
        for (Field field : fields) {
            String fieldName = field.getName();
            if (filters != null && filters.contains(fieldName)) continue;
            int modifier = field.getModifiers();
            if (!includeStatic && Modifier.isStatic(modifier) || !includeFinal && Modifier.isFinal(modifier) || !includeTransient && Modifier.isTransient(modifier) || jsonFields.contains(field)) continue;
            jsonFields.add(field);
        }
        return jsonFields;
    }

    public static Class getUnProxyType(Class clazz) {
        if (Proxy.isProxyClass(clazz)) {
            return Object.class;
        }
        Class type = clazz;
        while (type.isAnonymousClass() || type.getName().matches(Proxy_Type_Pattern)) {
            type = type.getSuperclass();
        }
        return type;
    }

    public static Object getProxiedObject(Object target) {
        try {
            if (ClazzHelper.isClassAvailable("org.springframework.aop.framework.Advised")) {
                return ClazzHelper.getAdvisedObject(target);
            }
            return target;
        }
        catch (Exception e) {
            Logger.warn((Object)"get proxy object error.", (Throwable[])new Throwable[]{e});
            return target;
        }
    }

    public static Object getAdvisedObject(Object target) {
        if (!ClazzHelper.isClassAvailable("org.springframework.aop.framework.Advised")) {
            return target;
        }
        if (target instanceof Advised) {
            try {
                return ((Advised)target).getTargetSource().getTarget();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return target;
    }
}

