/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.matcher.array;

import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

public class MapMatcher
extends BaseMatcher<Map<?, ?>> {
    private final Object expected;
    private final MapMatcherType type;

    public MapMatcher(Object expected, MapMatcherType type) {
        this.expected = expected;
        this.type = type;
    }

    public boolean matches(Object _actual) {
        if (!(_actual instanceof Map)) {
            return false;
        }
        Map actual = (Map)_actual;
        if (this.type == MapMatcherType.KEY) {
            return actual.containsKey(this.expected);
        }
        return actual.containsValue(this.expected);
    }

    public void describeTo(Description description) {
        if (this.type == MapMatcherType.KEY) {
            description.appendText(String.format("the map must have the key %s", this.expected));
        } else {
            description.appendText(String.format("the map must have the value %s", this.expected));
        }
    }

    public static enum MapMatcherType {
        KEY,
        VALUE;

    }
}

