/*
 * Decompiled with CFR 0.152.
 */
package org.test4j.hamcrest.iassert.interal;

import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Matcher;
import org.test4j.hamcrest.iassert.interal.IAssert;
import org.test4j.hamcrest.iassert.interal.MatcherBuilder;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.hamcrest.matcher.property.PropertiesEqualMatcher;
import org.test4j.hamcrest.matcher.property.PropertyEqualMatcher;
import org.test4j.hamcrest.matcher.property.PropertyEqualStringMatcher;
import org.test4j.hamcrest.matcher.property.PropertyItemMatcher;
import org.test4j.hamcrest.matcher.property.ReflectionEqualMatcher;
import org.test4j.hamcrest.matcher.string.StringMode;
import org.test4j.tools.datagen.IDataMap;

public interface IReflectionAssert<T, E extends IAssert>
extends IAssert<T, E> {
    default public E eqByProperties(String property, Object expected, EqMode ... modes) {
        if (expected instanceof Matcher) {
            throw new AssertionError((Object)"please use method[propertyMatch(String, Matcher)]");
        }
        PropertyEqualMatcher matcher = new PropertyEqualMatcher(expected, property, modes);
        return this.assertThat((Matcher)matcher);
    }

    default public E eqByProperties(String property, String expected, StringMode mode, StringMode ... more) {
        StringMode[] modes = new StringMode[more.length + 1];
        int index = 0;
        modes[index++] = mode;
        for (StringMode item : more) {
            modes[index++] = item;
        }
        PropertyEqualStringMatcher matcher = new PropertyEqualStringMatcher(expected, property, modes);
        return this.assertThat((Matcher)matcher);
    }

    default public E eqByProperties(String[] properties, Object expected, EqMode ... modes) {
        if (expected instanceof Matcher) {
            throw new AssertionError((Object)"please use method[propertyMatch(String, Matcher)]");
        }
        PropertiesEqualMatcher matcher = new PropertiesEqualMatcher(expected, properties, modes);
        return this.assertThat((Matcher)matcher);
    }

    default public E propertyMatch(String property, Matcher matcher) {
        PropertyItemMatcher _matcher = new PropertyItemMatcher(property, matcher);
        return this.assertThat((Matcher)_matcher);
    }

    default public E eqReflect(Object expected, EqMode ... modes) {
        if (expected instanceof Matcher) {
            throw new AssertionError((Object)"please use method[propertyMatch(String, Matcher)]");
        }
        if (expected instanceof IDataMap) {
            return this.eqDataMap((IDataMap)expected, modes);
        }
        ReflectionEqualMatcher matcher = new ReflectionEqualMatcher(expected, modes);
        return this.assertThat((Matcher)matcher);
    }

    default public E eqIgnoreDefault(Object expected) {
        if (expected instanceof Matcher) {
            throw new AssertionError((Object)"please use method[propertyMatch(String, Matcher)]");
        }
        ReflectionEqualMatcher matcher = new ReflectionEqualMatcher(expected, new EqMode[]{EqMode.IGNORE_DEFAULTS});
        return this.assertThat((Matcher)matcher);
    }

    default public E eqIgnoreAll(Object expected) {
        if (expected instanceof Matcher) {
            throw new AssertionError((Object)"please use method[propertyMatch(String, Matcher)]");
        }
        ReflectionEqualMatcher matcher = new ReflectionEqualMatcher(expected, new EqMode[]{EqMode.IGNORE_ORDER, EqMode.IGNORE_DEFAULTS, EqMode.IGNORE_DATES});
        return this.assertThat((Matcher)matcher);
    }

    default public E eqIgnoreOrder(Object expected) {
        if (expected instanceof Matcher) {
            throw new AssertionError((Object)"please use method[propertyMatch(String, Matcher)]");
        }
        ReflectionEqualMatcher matcher = new ReflectionEqualMatcher(expected, new EqMode[]{EqMode.IGNORE_ORDER});
        return this.assertThat((Matcher)matcher);
    }

    default public E eqMap(Map expected, EqMode ... modes) {
        if (expected instanceof IDataMap) {
            return this.eqDataMap((IDataMap)((Object)expected), modes);
        }
        return this.eqHashMap(expected, modes);
    }

    default public E eqHashMap(Map expected, EqMode ... modes) {
        if (expected instanceof IDataMap) {
            throw new RuntimeException("please use method: eqDataMap or eqMap");
        }
        ReflectionEqualMatcher matcher = new ReflectionEqualMatcher(expected, modes);
        return this.assertThat((Matcher)matcher);
    }

    default public E eqDataMap(IDataMap expected, EqMode ... modes) {
        if (this.getAssertObject().isArrayOrList()) {
            BaseMatcher matcher = MatcherBuilder.listEqMapMatcher(expected, modes);
            return this.assertThat((Matcher)matcher);
        }
        ReflectionEqualMatcher matcher = new ReflectionEqualMatcher(expected.row(0), modes);
        return this.assertThat((Matcher)matcher);
    }
}

