/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.service.invoker.CookieValueArgumentResolver;
import org.springframework.web.service.invoker.HttpClientAdapter;
import org.springframework.web.service.invoker.HttpMethodArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceMethod;
import org.springframework.web.service.invoker.PathVariableArgumentResolver;
import org.springframework.web.service.invoker.RequestAttributeArgumentResolver;
import org.springframework.web.service.invoker.RequestBodyArgumentResolver;
import org.springframework.web.service.invoker.RequestHeaderArgumentResolver;
import org.springframework.web.service.invoker.RequestParamArgumentResolver;
import org.springframework.web.service.invoker.UrlArgumentResolver;

public final class HttpServiceProxyFactory
implements InitializingBean,
EmbeddedValueResolverAware {
    private final HttpClientAdapter clientAdapter;
    @Nullable
    private List<HttpServiceArgumentResolver> customArgumentResolvers;
    @Nullable
    private List<HttpServiceArgumentResolver> argumentResolvers;
    @Nullable
    private ConversionService conversionService;
    @Nullable
    private StringValueResolver embeddedValueResolver;
    private ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
    private Duration blockTimeout = Duration.ofSeconds(5L);

    public HttpServiceProxyFactory(HttpClientAdapter clientAdapter) {
        Assert.notNull((Object)clientAdapter, (String)"HttpClientAdapter is required");
        this.clientAdapter = clientAdapter;
    }

    public void addCustomArgumentResolver(HttpServiceArgumentResolver resolver) {
        if (this.customArgumentResolvers == null) {
            this.customArgumentResolvers = new ArrayList<HttpServiceArgumentResolver>();
        }
        this.customArgumentResolvers.add(resolver);
    }

    public void setCustomArgumentResolvers(List<HttpServiceArgumentResolver> resolvers) {
        this.customArgumentResolvers = new ArrayList<HttpServiceArgumentResolver>(resolvers);
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
        this.reactiveAdapterRegistry = registry;
    }

    public void setBlockTimeout(Duration blockTimeout) {
        this.blockTimeout = blockTimeout;
    }

    public void afterPropertiesSet() throws Exception {
        this.conversionService = this.conversionService != null ? this.conversionService : new DefaultFormattingConversionService();
        this.argumentResolvers = this.initArgumentResolvers(this.conversionService);
    }

    private List<HttpServiceArgumentResolver> initArgumentResolvers(ConversionService conversionService) {
        ArrayList<HttpServiceArgumentResolver> resolvers = new ArrayList<HttpServiceArgumentResolver>();
        if (this.customArgumentResolvers != null) {
            resolvers.addAll(this.customArgumentResolvers);
        }
        resolvers.add(new RequestHeaderArgumentResolver(conversionService));
        resolvers.add(new RequestBodyArgumentResolver(this.reactiveAdapterRegistry));
        resolvers.add(new PathVariableArgumentResolver(conversionService));
        resolvers.add(new RequestParamArgumentResolver(conversionService));
        resolvers.add(new CookieValueArgumentResolver(conversionService));
        resolvers.add(new RequestAttributeArgumentResolver());
        resolvers.add(new UrlArgumentResolver());
        resolvers.add(new HttpMethodArgumentResolver());
        return resolvers;
    }

    public <S> S createClient(Class<S> serviceType) {
        List<HttpServiceMethod> httpServiceMethods = MethodIntrospector.selectMethods(serviceType, this::isExchangeMethod).stream().map(method -> this.createHttpServiceMethod(serviceType, (Method)method)).toList();
        return (S)ProxyFactory.getProxy(serviceType, (Interceptor)new HttpServiceMethodInterceptor(httpServiceMethods));
    }

    private boolean isExchangeMethod(Method method) {
        return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, HttpExchange.class);
    }

    private <S> HttpServiceMethod createHttpServiceMethod(Class<S> serviceType, Method method) {
        Assert.notNull(this.argumentResolvers, (String)"No argument resolvers: afterPropertiesSet was not called");
        return new HttpServiceMethod(method, serviceType, this.argumentResolvers, this.clientAdapter, this.embeddedValueResolver, this.reactiveAdapterRegistry, this.blockTimeout);
    }

    private static final class HttpServiceMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, HttpServiceMethod> httpServiceMethods;

        private HttpServiceMethodInterceptor(List<HttpServiceMethod> methods) {
            this.httpServiceMethods = methods.stream().collect(Collectors.toMap(HttpServiceMethod::getMethod, Function.identity()));
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            HttpServiceMethod httpServiceMethod = this.httpServiceMethods.get(method);
            if (httpServiceMethod != null) {
                return httpServiceMethod.invoke(invocation.getArguments());
            }
            if (method.isDefault() && invocation instanceof ReflectiveMethodInvocation) {
                ReflectiveMethodInvocation reflectiveMethodInvocation = (ReflectiveMethodInvocation)invocation;
                Object proxy = reflectiveMethodInvocation.getProxy();
                return InvocationHandler.invokeDefault(proxy, method, invocation.getArguments());
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }
    }
}

