/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class MultipartBodyBuilder {
    private final LinkedMultiValueMap<String, DefaultPartBuilder> parts = new LinkedMultiValueMap();

    public MultiValueMap<String, HttpEntity<?>> build() {
        LinkedMultiValueMap result = new LinkedMultiValueMap(this.parts.size());
        for (Map.Entry entry : this.parts.entrySet()) {
            for (DefaultPartBuilder builder : (List)entry.getValue()) {
                HttpEntity<?> entity = builder.build();
                result.add(entry.getKey(), entity);
            }
        }
        return result;
    }

    public PartBuilder part(String name, Object part) {
        return this.part(name, part, null);
    }

    public PartBuilder part(String name, Object part, @Nullable MediaType contentType) {
        Object partBody;
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull((Object)part, (String)"'part' must not be null");
        if (part instanceof Publisher) {
            throw new IllegalArgumentException("Use publisher(String, Publisher, Class) or publisher(String, Publisher, ParameterizedTypeReference) for adding Publisher parts");
        }
        HttpHeaders partHeaders = new HttpHeaders();
        if (part instanceof HttpEntity) {
            HttpEntity other = (HttpEntity)part;
            partBody = other.getBody();
            partHeaders.addAll(other.getHeaders());
        } else {
            partBody = part;
        }
        if (contentType != null) {
            partHeaders.setContentType(contentType);
        }
        DefaultPartBuilder builder = new DefaultPartBuilder(partBody, partHeaders);
        this.parts.add((Object)name, (Object)builder);
        return builder;
    }

    public <T, P extends Publisher<T>> PartBuilder asyncPart(String name, P publisher, Class<T> elementClass) {
        Assert.notNull(elementClass, (String)"'elementClass' must not be null");
        ResolvableType elementType = ResolvableType.forClass(elementClass);
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        HttpHeaders partHeaders = new HttpHeaders();
        PublisherPartBuilder<T, P> builder = new PublisherPartBuilder<T, P>(publisher, elementClass, partHeaders);
        this.parts.add((Object)name, builder);
        return builder;
    }

    public <T, P extends Publisher<T>> PartBuilder asyncPart(String name, P publisher, ParameterizedTypeReference<T> typeReference) {
        Assert.notNull(typeReference, (String)"'typeReference' must not be null");
        ResolvableType elementType1 = ResolvableType.forType(typeReference);
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        Assert.notNull((Object)elementType1, (String)"'typeReference' must not be null");
        HttpHeaders partHeaders = new HttpHeaders();
        PublisherPartBuilder<T, P> builder = new PublisherPartBuilder<T, P>(publisher, typeReference, partHeaders);
        this.parts.add((Object)name, builder);
        return builder;
    }

    public static final class PublisherEntity<T, P extends Publisher<T>>
    extends HttpEntity<P> {
        private final ResolvableType resolvableType;

        PublisherEntity(P publisher, ResolvableType resolvableType, @Nullable MultiValueMap<String, String> headers) {
            super(publisher, headers);
            Assert.notNull(publisher, (String)"'publisher' must not be null");
            Assert.notNull((Object)resolvableType, (String)"'resolvableType' must not be null");
            this.resolvableType = resolvableType;
        }

        public ResolvableType getResolvableType() {
            return this.resolvableType;
        }
    }

    private static class PublisherPartBuilder<S, P extends Publisher<S>>
    extends DefaultPartBuilder {
        private final ResolvableType resolvableType;

        public PublisherPartBuilder(P body, Class<S> elementClass, HttpHeaders headers) {
            super(body, headers);
            this.resolvableType = ResolvableType.forClass(elementClass);
        }

        public PublisherPartBuilder(P body, ParameterizedTypeReference<S> typeReference, HttpHeaders headers) {
            super(body, headers);
            this.resolvableType = ResolvableType.forType(typeReference);
        }

        @Override
        public HttpEntity<?> build() {
            Publisher publisher = (Publisher)this.body;
            Assert.state((publisher != null ? 1 : 0) != 0, (String)"'publisher' must not be null");
            return new PublisherEntity(publisher, this.resolvableType, this.headers);
        }
    }

    private static class DefaultPartBuilder
    implements PartBuilder {
        @Nullable
        protected final Object body;
        protected final HttpHeaders headers;

        public DefaultPartBuilder(@Nullable Object body, HttpHeaders headers) {
            this.body = body;
            this.headers = headers;
        }

        @Override
        public PartBuilder header(String headerName, String ... headerValues) {
            this.headers.addAll(headerName, Arrays.asList(headerValues));
            return this;
        }

        @Override
        public PartBuilder headers(Consumer<HttpHeaders> headersConsumer) {
            Assert.notNull(headersConsumer, (String)"'headersConsumer' must not be null");
            headersConsumer.accept(this.headers);
            return this;
        }

        public HttpEntity<?> build() {
            return new HttpEntity<Object>(this.body, this.headers);
        }
    }

    public static interface PartBuilder {
        public PartBuilder header(String var1, String ... var2);

        public PartBuilder headers(Consumer<HttpHeaders> var1);
    }
}

