/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletWebRequest
extends ServletRequestAttributes
implements NativeWebRequest {
    private static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HEADER_LAST_MODIFIED = "Last-Modified";
    private MultipartRequest multipartRequest;
    private HttpServletResponse response;
    private boolean notModified = false;

    public ServletWebRequest(HttpServletRequest request) {
        super(request);
        if (request instanceof MultipartRequest) {
            this.multipartRequest = (MultipartRequest)request;
        }
    }

    public ServletWebRequest(HttpServletRequest request, HttpServletResponse response) {
        this(request);
        this.response = response;
    }

    public final HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public Object getNativeRequest() {
        return this.getRequest();
    }

    @Override
    public Object getNativeResponse() {
        return this.getResponse();
    }

    @Override
    public String getHeader(String headerName) {
        return this.getRequest().getHeader(headerName);
    }

    @Override
    public String[] getHeaderValues(String headerName) {
        Object[] headerValues = StringUtils.toStringArray((Enumeration)this.getRequest().getHeaders(headerName));
        return !ObjectUtils.isEmpty((Object[])headerValues) ? headerValues : null;
    }

    @Override
    public Iterator<String> getHeaderNames() {
        return CollectionUtils.toIterator((Enumeration)this.getRequest().getHeaderNames());
    }

    @Override
    public String getParameter(String paramName) {
        return this.getRequest().getParameter(paramName);
    }

    @Override
    public String[] getParameterValues(String paramName) {
        return this.getRequest().getParameterValues(paramName);
    }

    @Override
    public Iterator<String> getParameterNames() {
        return CollectionUtils.toIterator((Enumeration)this.getRequest().getParameterNames());
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.getRequest().getParameterMap();
    }

    @Override
    public Locale getLocale() {
        return this.getRequest().getLocale();
    }

    @Override
    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    @Override
    public String getRemoteUser() {
        return this.getRequest().getRemoteUser();
    }

    @Override
    public Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.getRequest().isUserInRole(role);
    }

    @Override
    public boolean isSecure() {
        return this.getRequest().isSecure();
    }

    @Override
    public boolean checkNotModified(long lastModifiedTimestamp) {
        if (!(lastModifiedTimestamp < 0L || this.notModified || this.response != null && this.response.containsHeader(HEADER_LAST_MODIFIED))) {
            long ifModifiedSince = this.getRequest().getDateHeader(HEADER_IF_MODIFIED_SINCE);
            boolean bl = this.notModified = ifModifiedSince >= lastModifiedTimestamp / 1000L * 1000L;
            if (this.response != null) {
                if (this.notModified) {
                    this.response.setStatus(304);
                } else {
                    this.response.setDateHeader(HEADER_LAST_MODIFIED, lastModifiedTimestamp);
                }
            }
        }
        return this.notModified;
    }

    public boolean isNotModified() {
        return this.notModified;
    }

    @Override
    public String getDescription(boolean includeClientInfo) {
        HttpServletRequest request = this.getRequest();
        StringBuilder sb = new StringBuilder();
        sb.append("uri=").append(request.getRequestURI());
        if (includeClientInfo) {
            String user;
            HttpSession session;
            String client = request.getRemoteAddr();
            if (StringUtils.hasLength((String)client)) {
                sb.append(";client=").append(client);
            }
            if ((session = request.getSession(false)) != null) {
                sb.append(";session=").append(session.getId());
            }
            if (StringUtils.hasLength((String)(user = request.getRemoteUser()))) {
                sb.append(";user=").append(user);
            }
        }
        return sb.toString();
    }

    @Override
    public Iterator<String> getFileNames() {
        if (this.multipartRequest == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return this.multipartRequest.getFileNames();
    }

    @Override
    public MultipartFile getFile(String name) {
        if (this.multipartRequest == null) {
            return null;
        }
        return this.multipartRequest.getFile(name);
    }

    @Override
    public List<MultipartFile> getFiles(String name) {
        if (this.multipartRequest == null) {
            return null;
        }
        return this.multipartRequest.getFiles(name);
    }

    @Override
    public Map<String, MultipartFile> getFileMap() {
        if (this.multipartRequest == null) {
            return Collections.emptyMap();
        }
        return this.multipartRequest.getFileMap();
    }

    @Override
    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        if (this.multipartRequest == null) {
            return new LinkedMultiValueMap();
        }
        return this.multipartRequest.getMultiFileMap();
    }

    @Override
    public String toString() {
        return "ServletWebRequest: " + this.getDescription(true);
    }
}

