/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.metadata.TableMetaDataProvider;
import org.springframework.jdbc.core.metadata.TableMetaDataProviderFactory;
import org.springframework.jdbc.core.metadata.TableParameterMetaData;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class TableMetaDataContext {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private @Nullable String tableName;
    private @Nullable String catalogName;
    private @Nullable String schemaName;
    private boolean accessTableColumnMetaData = true;
    private boolean overrideIncludeSynonymsDefault = false;
    private boolean quoteIdentifiers = false;
    private @Nullable TableMetaDataProvider metaDataProvider;
    private List<String> tableColumns = new ArrayList<String>();
    private boolean generatedKeyColumnsUsed = false;

    public void setTableName(@Nullable String tableName) {
        this.tableName = tableName;
    }

    public @Nullable String getTableName() {
        return this.tableName;
    }

    public void setCatalogName(@Nullable String catalogName) {
        this.catalogName = catalogName;
    }

    public @Nullable String getCatalogName() {
        return this.catalogName;
    }

    public void setSchemaName(@Nullable String schemaName) {
        this.schemaName = schemaName;
    }

    public @Nullable String getSchemaName() {
        return this.schemaName;
    }

    public void setAccessTableColumnMetaData(boolean accessTableColumnMetaData) {
        this.accessTableColumnMetaData = accessTableColumnMetaData;
    }

    public boolean isAccessTableColumnMetaData() {
        return this.accessTableColumnMetaData;
    }

    public void setOverrideIncludeSynonymsDefault(boolean override) {
        this.overrideIncludeSynonymsDefault = override;
    }

    public boolean isOverrideIncludeSynonymsDefault() {
        return this.overrideIncludeSynonymsDefault;
    }

    public void setQuoteIdentifiers(boolean quoteIdentifiers) {
        this.quoteIdentifiers = quoteIdentifiers;
    }

    public boolean isQuoteIdentifiers() {
        return this.quoteIdentifiers;
    }

    public List<String> getTableColumns() {
        return this.tableColumns;
    }

    public void processMetaData(DataSource dataSource, List<String> declaredColumns, String[] generatedKeyNames) {
        this.metaDataProvider = TableMetaDataProviderFactory.createMetaDataProvider(dataSource, this);
        this.tableColumns = this.reconcileColumnsToUse(declaredColumns, generatedKeyNames);
    }

    private TableMetaDataProvider obtainMetaDataProvider() {
        Assert.state((this.metaDataProvider != null ? 1 : 0) != 0, (String)"No TableMetaDataProvider - call processMetaData first");
        return this.metaDataProvider;
    }

    protected List<String> reconcileColumnsToUse(List<String> declaredColumns, String[] generatedKeyNames) {
        if (generatedKeyNames.length > 0) {
            this.generatedKeyColumnsUsed = true;
        }
        if (!declaredColumns.isEmpty()) {
            return new ArrayList<String>(declaredColumns);
        }
        LinkedHashSet keys = CollectionUtils.newLinkedHashSet((int)generatedKeyNames.length);
        for (String key : generatedKeyNames) {
            keys.add(key.toUpperCase(Locale.ROOT));
        }
        ArrayList<String> columns = new ArrayList<String>();
        for (TableParameterMetaData meta : this.obtainMetaDataProvider().getTableParameterMetaData()) {
            if (keys.contains(meta.getParameterName().toUpperCase(Locale.ROOT))) continue;
            columns.add(meta.getParameterName());
        }
        return columns;
    }

    public List<Object> matchInParameterValuesWithInsertColumns(SqlParameterSource parameterSource) {
        ArrayList<Object> values = new ArrayList<Object>();
        Map<String, String> caseInsensitiveParameterNames = SqlParameterSourceUtils.extractCaseInsensitiveParameterNames(parameterSource);
        for (String column : this.tableColumns) {
            if (parameterSource.hasValue(column)) {
                values.add(SqlParameterSourceUtils.getTypedValue(parameterSource, column));
                continue;
            }
            String lowerCaseName = column.toLowerCase(Locale.ROOT);
            if (parameterSource.hasValue(lowerCaseName)) {
                values.add(SqlParameterSourceUtils.getTypedValue(parameterSource, lowerCaseName));
                continue;
            }
            String propertyName = JdbcUtils.convertUnderscoreNameToPropertyName(column);
            if (parameterSource.hasValue(propertyName)) {
                values.add(SqlParameterSourceUtils.getTypedValue(parameterSource, propertyName));
                continue;
            }
            if (caseInsensitiveParameterNames.containsKey(lowerCaseName)) {
                values.add(SqlParameterSourceUtils.getTypedValue(parameterSource, caseInsensitiveParameterNames.get(lowerCaseName)));
                continue;
            }
            values.add(null);
        }
        return values;
    }

    public List<Object> matchInParameterValuesWithInsertColumns(Map<String, ?> inParameters) {
        ArrayList<Object> values = new ArrayList<Object>(inParameters.size());
        for (String column : this.tableColumns) {
            Object value = inParameters.get(column);
            if (value == null && (value = inParameters.get(column.toLowerCase(Locale.ROOT))) == null) {
                for (Map.Entry<String, ?> entry : inParameters.entrySet()) {
                    if (!column.equalsIgnoreCase(entry.getKey())) continue;
                    value = entry.getValue();
                    break;
                }
            }
            values.add(value);
        }
        return values;
    }

    public String createInsertString(String ... generatedKeyNames) {
        String schemaName;
        LinkedHashSet keys = CollectionUtils.newLinkedHashSet((int)generatedKeyNames.length);
        for (String key : generatedKeyNames) {
            keys.add(key.toUpperCase(Locale.ROOT));
        }
        String identifierQuoteString = this.isQuoteIdentifiers() ? this.obtainMetaDataProvider().getIdentifierQuoteString() : null;
        QuoteHandler quoteHandler = new QuoteHandler(identifierQuoteString);
        StringBuilder insertStatement = new StringBuilder();
        insertStatement.append("INSERT INTO ");
        String catalogName = this.getCatalogName();
        if (catalogName != null) {
            quoteHandler.appendTo(insertStatement, catalogName);
            insertStatement.append('.');
        }
        if ((schemaName = this.getSchemaName()) != null) {
            quoteHandler.appendTo(insertStatement, schemaName);
            insertStatement.append('.');
        }
        String tableName = this.getTableName();
        quoteHandler.appendTo(insertStatement, tableName);
        insertStatement.append(" (");
        int columnCount = 0;
        for (String columnName : this.getTableColumns()) {
            if (keys.contains(columnName.toUpperCase(Locale.ROOT))) continue;
            if (++columnCount > 1) {
                insertStatement.append(", ");
            }
            quoteHandler.appendTo(insertStatement, columnName);
        }
        insertStatement.append(") VALUES(");
        if (columnCount < 1) {
            if (this.generatedKeyColumnsUsed) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Unable to locate non-key columns for table '" + tableName + "' so an empty insert statement is generated"));
                }
            } else {
                String message = "Unable to locate columns for table '" + tableName + "' so an insert statement can't be generated.";
                if (this.isAccessTableColumnMetaData()) {
                    message = message + " Consider specifying explicit column names -- for example, via SimpleJdbcInsert#usingColumns().";
                }
                throw new InvalidDataAccessApiUsageException(message);
            }
        }
        String params = String.join((CharSequence)", ", Collections.nCopies(columnCount, "?"));
        insertStatement.append(params);
        insertStatement.append(')');
        return insertStatement.toString();
    }

    public int[] createInsertTypes() {
        int[] types = new int[this.getTableColumns().size()];
        List<TableParameterMetaData> parameters = this.obtainMetaDataProvider().getTableParameterMetaData();
        LinkedHashMap parameterMap = CollectionUtils.newLinkedHashMap((int)parameters.size());
        for (TableParameterMetaData tpmd : parameters) {
            parameterMap.put(tpmd.getParameterName().toUpperCase(Locale.ROOT), tpmd);
        }
        int typeIndx = 0;
        for (String column : this.getTableColumns()) {
            TableParameterMetaData tpmd;
            types[typeIndx] = column == null ? Integer.MIN_VALUE : ((tpmd = (TableParameterMetaData)parameterMap.get(column.toUpperCase(Locale.ROOT))) != null ? tpmd.getSqlType() : Integer.MIN_VALUE);
            ++typeIndx;
        }
        return types;
    }

    public boolean isGetGeneratedKeysSupported() {
        return this.obtainMetaDataProvider().isGetGeneratedKeysSupported();
    }

    public boolean isGetGeneratedKeysSimulated() {
        return this.obtainMetaDataProvider().isGetGeneratedKeysSimulated();
    }

    public @Nullable String getSimpleQueryForGetGeneratedKey(String tableName, String keyColumnName) {
        return this.obtainMetaDataProvider().getSimpleQueryForGetGeneratedKey(tableName, keyColumnName);
    }

    public boolean isGeneratedKeysColumnNameArraySupported() {
        return this.obtainMetaDataProvider().isGeneratedKeysColumnNameArraySupported();
    }

    private static final class QuoteHandler {
        private final @Nullable String identifierQuoteString;
        private final boolean quoting;

        QuoteHandler(@Nullable String identifierQuoteString) {
            this.identifierQuoteString = identifierQuoteString;
            this.quoting = StringUtils.hasText((String)identifierQuoteString);
        }

        void appendTo(StringBuilder stringBuilder, @Nullable String item) {
            if (this.quoting) {
                stringBuilder.append(this.identifierQuoteString).append(item).append(this.identifierQuoteString);
            } else {
                stringBuilder.append(item);
            }
        }
    }
}

