/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jspecify.annotations.Nullable;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.metadata.CallParameterMetaData;
import org.springframework.jdbc.core.metadata.GenericCallMetaDataProvider;

public class PostgresCallMetaDataProvider
extends GenericCallMetaDataProvider {
    private static final String RETURN_VALUE_NAME = "returnValue";
    private final String schemaName;

    public PostgresCallMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        super(databaseMetaData);
        String schema = databaseMetaData.getConnection().getSchema();
        this.schemaName = schema != null ? schema : "public";
    }

    @Override
    public boolean isReturnResultSetSupported() {
        return false;
    }

    @Override
    public boolean isRefCursorSupported() {
        return true;
    }

    @Override
    public int getRefCursorSqlType() {
        return 1111;
    }

    @Override
    public @Nullable String metaDataSchemaNameToUse(@Nullable String schemaName) {
        return schemaName == null ? this.schemaName : super.metaDataSchemaNameToUse(schemaName);
    }

    @Override
    public SqlParameter createDefaultOutParameter(String parameterName, CallParameterMetaData meta) {
        if (meta.getSqlType() == 1111 && "refcursor".equals(meta.getTypeName())) {
            return new SqlOutParameter(parameterName, this.getRefCursorSqlType(), new ColumnMapRowMapper());
        }
        return super.createDefaultOutParameter(parameterName, meta);
    }

    @Override
    public boolean byPassReturnParameter(String parameterName) {
        return RETURN_VALUE_NAME.equals(parameterName);
    }
}

