/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import org.springframework.scheduling.concurrent.ReschedulingRunnable;
import org.springframework.scheduling.support.TaskUtils;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ErrorHandler;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureTask;

public class ThreadPoolTaskScheduler
extends ExecutorConfigurationSupport
implements AsyncListenableTaskExecutor,
SchedulingTaskExecutor,
TaskScheduler {
    private static final TimeUnit NANO = TimeUnit.NANOSECONDS;
    private volatile int poolSize = 1;
    private volatile boolean removeOnCancelPolicy;
    private volatile boolean continueExistingPeriodicTasksAfterShutdownPolicy;
    private volatile boolean executeExistingDelayedTasksAfterShutdownPolicy = true;
    @Nullable
    private volatile ErrorHandler errorHandler;
    private Clock clock = Clock.systemDefaultZone();
    @Nullable
    private ScheduledExecutorService scheduledExecutor;
    private final Map<Object, ListenableFuture<?>> listenableFutureMap = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    public void setPoolSize(int poolSize) {
        Assert.isTrue((poolSize > 0 ? 1 : 0) != 0, (String)"'poolSize' must be 1 or higher");
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor threadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            threadPoolExecutor.setCorePoolSize(poolSize);
        }
        this.poolSize = poolSize;
    }

    public void setRemoveOnCancelPolicy(boolean flag) {
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor threadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            threadPoolExecutor.setRemoveOnCancelPolicy(flag);
        }
        this.removeOnCancelPolicy = flag;
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean flag) {
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor threadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            threadPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(flag);
        }
        this.continueExistingPeriodicTasksAfterShutdownPolicy = flag;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean flag) {
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor threadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            threadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(flag);
        }
        this.executeExistingDelayedTasksAfterShutdownPolicy = flag;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"Clock must not be null");
        this.clock = clock;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    protected ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        this.scheduledExecutor = this.createExecutor(this.poolSize, threadFactory, rejectedExecutionHandler);
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor threadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            if (this.removeOnCancelPolicy) {
                threadPoolExecutor.setRemoveOnCancelPolicy(true);
            }
            if (this.continueExistingPeriodicTasksAfterShutdownPolicy) {
                threadPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(true);
            }
            if (!this.executeExistingDelayedTasksAfterShutdownPolicy) {
                threadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            }
        }
        return this.scheduledExecutor;
    }

    protected ScheduledExecutorService createExecutor(int poolSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return new ScheduledThreadPoolExecutor(poolSize, threadFactory, rejectedExecutionHandler);
    }

    public ScheduledExecutorService getScheduledExecutor() throws IllegalStateException {
        Assert.state((this.scheduledExecutor != null ? 1 : 0) != 0, (String)"ThreadPoolTaskScheduler not initialized");
        return this.scheduledExecutor;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() throws IllegalStateException {
        Assert.state((boolean)(this.scheduledExecutor instanceof ScheduledThreadPoolExecutor), (String)"No ScheduledThreadPoolExecutor available");
        return (ScheduledThreadPoolExecutor)this.scheduledExecutor;
    }

    public int getPoolSize() {
        if (this.scheduledExecutor == null) {
            return this.poolSize;
        }
        return this.getScheduledThreadPoolExecutor().getPoolSize();
    }

    public int getActiveCount() {
        if (this.scheduledExecutor == null) {
            return 0;
        }
        return this.getScheduledThreadPoolExecutor().getActiveCount();
    }

    @Deprecated
    public boolean isRemoveOnCancelPolicy() {
        if (this.scheduledExecutor == null) {
            return this.removeOnCancelPolicy;
        }
        return this.getScheduledThreadPoolExecutor().getRemoveOnCancelPolicy();
    }

    public void execute(Runnable task) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            executor.execute(this.errorHandlingTask(task, false));
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    @Deprecated
    public void execute(Runnable task, long startTimeout) {
        this.execute(task);
    }

    public Future<?> submit(Runnable task) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            return executor.submit(this.errorHandlingTask(task, false));
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    public <T> Future<T> submit(Callable<T> task) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            Callable<T> taskToUse = task;
            ErrorHandler errorHandler = this.errorHandler;
            if (errorHandler != null) {
                taskToUse = new DelegatingErrorHandlingCallable<T>(task, errorHandler);
            }
            return executor.submit(taskToUse);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            ListenableFutureTask listenableFuture = new ListenableFutureTask(task, null);
            this.executeAndTrack(executor, listenableFuture);
            return listenableFuture;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            ListenableFutureTask listenableFuture = new ListenableFutureTask(task);
            this.executeAndTrack(executor, listenableFuture);
            return listenableFuture;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    private void executeAndTrack(ExecutorService executor, ListenableFutureTask<?> listenableFuture) {
        Future<?> scheduledFuture = executor.submit(this.errorHandlingTask((Runnable)listenableFuture, false));
        this.listenableFutureMap.put(scheduledFuture, (ListenableFuture<?>)listenableFuture);
        listenableFuture.addCallback(result -> this.listenableFutureMap.remove(scheduledFuture), ex -> this.listenableFutureMap.remove(scheduledFuture));
    }

    @Override
    protected void cancelRemainingTask(Runnable task) {
        super.cancelRemainingTask(task);
        ListenableFuture<?> listenableFuture = this.listenableFutureMap.get(task);
        if (listenableFuture != null) {
            listenableFuture.cancel(true);
        }
    }

    @Override
    @Nullable
    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            ErrorHandler errorHandler = this.errorHandler;
            if (errorHandler == null) {
                errorHandler = TaskUtils.getDefaultErrorHandler(true);
            }
            return new ReschedulingRunnable(task, trigger, this.clock, executor, errorHandler).schedule();
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, Instant startTime) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        Duration delay = Duration.between(this.clock.instant(), startTime);
        try {
            return executor.schedule(this.errorHandlingTask(task, false), NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Instant startTime, Duration period) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        Duration initialDelay = Duration.between(this.clock.instant(), startTime);
        try {
            return executor.scheduleAtFixedRate(this.errorHandlingTask(task, true), NANO.convert(initialDelay), NANO.convert(period), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Duration period) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            return executor.scheduleAtFixedRate(this.errorHandlingTask(task, true), 0L, NANO.convert(period), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Instant startTime, Duration delay) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        Duration initialDelay = Duration.between(this.clock.instant(), startTime);
        try {
            return executor.scheduleWithFixedDelay(this.errorHandlingTask(task, true), NANO.convert(initialDelay), NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Duration delay) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            return executor.scheduleWithFixedDelay(this.errorHandlingTask(task, true), 0L, NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + executor + "] did not accept task: " + task, (Throwable)ex);
        }
    }

    private Runnable errorHandlingTask(Runnable task, boolean isRepeatingTask) {
        return TaskUtils.decorateTaskWithErrorHandler(task, this.errorHandler, isRepeatingTask);
    }

    private static class DelegatingErrorHandlingCallable<V>
    implements Callable<V> {
        private final Callable<V> delegate;
        private final ErrorHandler errorHandler;

        public DelegatingErrorHandlingCallable(Callable<V> delegate, ErrorHandler errorHandler) {
            this.delegate = delegate;
            this.errorHandler = errorHandler;
        }

        @Override
        @Nullable
        public V call() throws Exception {
            try {
                return this.delegate.call();
            }
            catch (Throwable ex) {
                this.errorHandler.handleError(ex);
                return null;
            }
        }
    }
}

