/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class BeanValidationPostProcessor
implements BeanPostProcessor,
InitializingBean {
    private Validator validator;

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validator = validatorFactory.getValidator();
    }

    public void afterPropertiesSet() {
        if (this.validator == null) {
            Validation.buildDefaultValidatorFactory().getValidator();
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Set result = this.validator.validate(bean, new Class[0]);
        if (!result.isEmpty()) {
            StringBuilder sb = new StringBuilder("Bean state is invalid: ");
            Iterator it = result.iterator();
            while (it.hasNext()) {
                ConstraintViolation violation = (ConstraintViolation)it.next();
                sb.append(violation.getPropertyPath()).append(" - ").append(violation.getMessage());
                if (!it.hasNext()) continue;
                sb.append("; ");
            }
            throw new BeanInitializationException(sb.toString());
        }
        return bean;
    }
}

