/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;

public class StringOrBytesSerializer
implements Serializer<Object> {
    private final StringSerializer stringSerializer = new StringSerializer();

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.stringSerializer.configure(configs, isKey);
    }

    public byte[] serialize(String topic, Object data) {
        if (data instanceof byte[]) {
            return (byte[])data;
        }
        if (data instanceof Bytes) {
            return ((Bytes)data).get();
        }
        if (data instanceof String) {
            return this.stringSerializer.serialize(topic, (String)data);
        }
        if (data == null) {
            return null;
        }
        throw new IllegalStateException("This serializer can only handle byte[], Bytes or String values");
    }

    public void close() {
        this.stringSerializer.close();
    }
}

