/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DelegatingSerializer
implements Serializer<Object> {
    @Deprecated
    public static final String SERIALIZATION_SELECTOR = "spring.kafka.serialization.selector";
    public static final String VALUE_SERIALIZATION_SELECTOR = "spring.kafka.serialization.selector";
    public static final String KEY_SERIALIZATION_SELECTOR = "spring.kafka.key.serialization.selector";
    @Deprecated
    public static final String SERIALIZATION_SELECTOR_CONFIG = "spring.kafka.serialization.selector.config";
    public static final String VALUE_SERIALIZATION_SELECTOR_CONFIG = "spring.kafka.serialization.selector.config";
    public static final String KEY_SERIALIZATION_SELECTOR_CONFIG = "spring.kafka.key.serialization.selector.config";
    private final Map<String, Serializer<?>> delegates = new HashMap();
    private boolean forKeys;

    public DelegatingSerializer() {
    }

    public DelegatingSerializer(Map<String, Serializer<?>> delegates) {
        this.delegates.putAll(delegates);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.forKeys = isKey;
        String configKey = this.configKey();
        Object value = configs.get(configKey);
        if (value == null) {
            return;
        }
        if (value instanceof Map) {
            ((Map)value).forEach((selector, serializer) -> {
                if (serializer instanceof Serializer) {
                    this.delegates.put((String)selector, (Serializer<?>)((Serializer)serializer));
                } else if (serializer instanceof Class) {
                    DelegatingSerializer.instantiateAndConfigure(configs, isKey, this.delegates, selector, (Class)serializer);
                } else if (serializer instanceof String) {
                    DelegatingSerializer.createInstanceAndConfigure(configs, isKey, this.delegates, selector, (String)serializer);
                } else {
                    throw new IllegalStateException(configKey + " map entries must be Serializers or class names, not " + value.getClass());
                }
            });
        } else if (value instanceof String) {
            this.delegates.putAll(DelegatingSerializer.createDelegates((String)value, configs, isKey));
        } else {
            throw new IllegalStateException(configKey + " must be a map or String, not " + value.getClass());
        }
    }

    private String configKey() {
        return this.forKeys ? KEY_SERIALIZATION_SELECTOR_CONFIG : "spring.kafka.serialization.selector.config";
    }

    protected static Map<String, Serializer<?>> createDelegates(String mappings, Map<String, ?> configs, boolean isKey) {
        String[] array;
        HashMap delegateMap = new HashMap();
        for (String entry : array = StringUtils.commaDelimitedListToStringArray((String)mappings)) {
            String[] split = entry.split(":");
            Assert.isTrue((split.length == 2 ? 1 : 0) != 0, (String)"Each comma-delimited selector entry must have exactly one ':'");
            DelegatingSerializer.createInstanceAndConfigure(configs, isKey, delegateMap, split[0], split[1]);
        }
        return delegateMap;
    }

    protected static void createInstanceAndConfigure(Map<String, ?> configs, boolean isKey, Map<String, Serializer<?>> delegateMap, String selector, String className) {
        try {
            Class clazz = ClassUtils.forName((String)className.trim(), (ClassLoader)ClassUtils.getDefaultClassLoader());
            DelegatingSerializer.instantiateAndConfigure(configs, isKey, delegateMap, selector, clazz);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected static void instantiateAndConfigure(Map<String, ?> configs, boolean isKey, Map<String, Serializer<?>> delegateMap, String selector, Class<?> clazz) {
        try {
            Serializer delegate = (Serializer)clazz.newInstance();
            delegate.configure(configs, isKey);
            delegateMap.put(selector.trim(), delegate);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void addDelegate(String selector, Serializer<?> serializer) {
        this.delegates.put(selector, serializer);
    }

    @Nullable
    public Serializer<?> removeDelegate(String selector) {
        return this.delegates.remove(selector);
    }

    public byte[] serialize(String topic, Object data) {
        throw new UnsupportedOperationException();
    }

    public byte[] serialize(String topic, Headers headers, Object data) {
        byte[] value = null;
        String selectorKey = this.selectorKey();
        Header header = headers.lastHeader(selectorKey);
        if (header != null) {
            value = header.value();
        }
        if (value == null) {
            throw new IllegalStateException("No '" + selectorKey + "' header present");
        }
        String selector = new String(value).replaceAll("\"", "");
        Serializer<?> serializer = this.delegates.get(selector);
        if (serializer == null) {
            throw new IllegalStateException("No serializer found for '" + selectorKey + "' header with value '" + selector + "'");
        }
        return serializer.serialize(topic, headers, data);
    }

    private String selectorKey() {
        return this.forKeys ? KEY_SERIALIZATION_SELECTOR : "spring.kafka.serialization.selector";
    }

    public void close() {
        this.delegates.values().forEach(ser -> ser.close());
    }
}

