/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.maven;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.springframework.aot.build.GenerateBootstrapCommand;
import org.springframework.aot.maven.AbstractBootstrapMojo;
import org.springframework.util.StringUtils;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateMojo
extends AbstractBootstrapMojo {
    @Parameter(property="spring.aot.mainClass")
    protected String mainClass;
    @Parameter(property="spring.aot.applicationClass")
    protected String applicationClass;
    @Parameter(defaultValue="${project.build.directory}/generated-runtime-sources/spring-aot/")
    private File generatedSourcesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().debug((CharSequence)"generate goal could not be applied to pom project.");
            return;
        }
        HashSet<Path> resourceFolders = new HashSet<Path>();
        for (Resource r : this.project.getResources()) {
            resourceFolders.add(new File(r.getDirectory()).toPath());
        }
        this.recreateGeneratedSourcesFolder(this.generatedSourcesDirectory);
        Path sourcesPath = this.generatedSourcesDirectory.toPath().resolve(Paths.get("src", "main", "java"));
        Path resourcesPath = this.generatedSourcesDirectory.toPath().resolve(Paths.get("src", "main", "resources"));
        try {
            List<String> runtimeClasspathElements = this.project.getRuntimeClasspathElements().stream().filter(element -> !element.contains("spring-boot-devtools")).collect(Collectors.toList());
            GenerateMojo.findJarFile(this.pluginArtifacts, "org.springframework.experimental", "spring-native-configuration").ifPresent(artifact -> GenerateMojo.prependDependency(artifact, runtimeClasspathElements));
            GenerateMojo.findJarFile(this.pluginArtifacts, "org.springframework.experimental", "spring-aot").ifPresent(artifact -> GenerateMojo.prependDependency(artifact, runtimeClasspathElements));
            GenerateMojo.findJarFile(this.pluginArtifacts, "org.springframework.boot", "spring-boot-loader-tools").ifPresent(artifact -> GenerateMojo.prependDependency(artifact, runtimeClasspathElements));
            GenerateMojo.findJarFile(this.pluginArtifacts, "com.squareup", "javapoet").ifPresent(artifact -> GenerateMojo.prependDependency(artifact, runtimeClasspathElements));
            GenerateMojo.findJarFile(this.pluginArtifacts, "info.picocli", "picocli").ifPresent(artifact -> GenerateMojo.prependDependency(artifact, runtimeClasspathElements));
            GenerateMojo.findJarFile(this.pluginArtifacts, "net.bytebuddy", "byte-buddy").ifPresent(artifact -> GenerateMojo.prependDependency(artifact, runtimeClasspathElements));
            ArrayList<String> args = new ArrayList<String>();
            if ("true".equals(this.debug)) {
                args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=8000");
            } else {
                args.addAll(Arrays.asList(CommandLineUtils.translateCommandline((String)this.debug)));
            }
            args.add("-cp");
            args.add(GenerateMojo.asClasspathArgument(runtimeClasspathElements));
            args.add(GenerateBootstrapCommand.class.getCanonicalName());
            args.add("--sources-out=" + sourcesPath.toAbsolutePath());
            args.add("--resources-out=" + resourcesPath.toAbsolutePath());
            args.add("--resources=" + StringUtils.collectionToDelimitedString(resourceFolders, (String)File.pathSeparator));
            args.add("--classes=" + this.project.getBuild().getOutputDirectory());
            this.applyAotOptions(args);
            if (this.mainClass != null) {
                args.add("--main-class=" + this.mainClass);
            }
            if (this.applicationClass != null) {
                args.add("--application-class=" + this.applicationClass);
            }
            this.forkJvm(Paths.get(this.project.getBuild().getDirectory(), new String[0]).toFile(), args, Collections.emptyMap());
            this.compileGeneratedSources(sourcesPath, runtimeClasspathElements);
            this.processGeneratedResources(resourcesPath, Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]));
            this.buildContext.refresh(this.buildDir);
        }
        catch (Throwable exc) {
            this.getLog().error(exc);
            this.getLog().error((CharSequence)Arrays.toString(exc.getStackTrace()));
            throw new MojoFailureException("Build failed during Spring AOT code generation", exc);
        }
    }

    protected void compileGeneratedSources(Path sourcesPath, List<String> runtimeClasspathElements) throws MojoExecutionException {
        String compilerVersion = this.project.getProperties().getProperty("maven-compiler-plugin.version", "3.8.1");
        this.project.addCompileSourceRoot(sourcesPath.toString());
        Xpp3Dom compilerConfig = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"compileSourceRoots", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"compileSourceRoot", (String)sourcesPath.toString())}), MojoExecutor.element((String)"compilePath", (MojoExecutor.Element[])((MojoExecutor.Element[])runtimeClasspathElements.stream().map(classpathElement -> MojoExecutor.element((String)"compilePath", (String)classpathElement)).toArray(MojoExecutor.Element[]::new)))});
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-compiler-plugin"), (String)MojoExecutor.version((String)compilerVersion)), (String)MojoExecutor.goal((String)"compile"), (Xpp3Dom)compilerConfig, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    protected void processGeneratedResources(Path sourcePath, Path destinationPath) throws MojoExecutionException {
        String resourcesVersion = this.project.getProperties().getProperty("maven-resources-plugin.version", "3.2.0");
        Xpp3Dom resourceConfig = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)sourcePath.toString())})}), MojoExecutor.element((String)"outputDirectory", (String)destinationPath.toString())});
        Resource resource = new Resource();
        resource.setDirectory(sourcePath.toString());
        this.project.addResource(resource);
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)resourcesVersion)), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)resourceConfig, (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }
}

