/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.support;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.EnvironmentPostProcessor;
import org.springframework.boot.bootstrap.ConfigurableBootstrapContext;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.boot.support.ReflectionEnvironmentPostProcessorsFactory;
import org.springframework.boot.support.SpringFactoriesEnvironmentPostProcessorsFactory;
import org.springframework.core.io.support.SpringFactoriesLoader;

@FunctionalInterface
public interface EnvironmentPostProcessorsFactory {
    public List<EnvironmentPostProcessor> getEnvironmentPostProcessors(DeferredLogFactory var1, ConfigurableBootstrapContext var2);

    public static EnvironmentPostProcessorsFactory fromSpringFactories(@Nullable ClassLoader classLoader) {
        return new SpringFactoriesEnvironmentPostProcessorsFactory(SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)classLoader));
    }

    public static EnvironmentPostProcessorsFactory of(Class<?> ... classes) {
        return new ReflectionEnvironmentPostProcessorsFactory(classes);
    }

    public static EnvironmentPostProcessorsFactory of(String ... classNames) {
        return EnvironmentPostProcessorsFactory.of(null, classNames);
    }

    public static EnvironmentPostProcessorsFactory of(@Nullable ClassLoader classLoader, String ... classNames) {
        return new ReflectionEnvironmentPostProcessorsFactory(classLoader, classNames);
    }
}

