/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics.analyzer;

import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.diagnostics.FailureAnalyzer;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Order(value=0x7FFFFFFF)
class MissingParameterNamesFailureAnalyzer
implements FailureAnalyzer {
    private static final String USE_PARAMETERS_MESSAGE = "Ensure that the compiler uses the '-parameters' flag";
    static final String POSSIBILITY = "This may be due to missing parameter name information";
    static final String ACTION = "Ensure that your compiler is configured to use the '-parameters' flag.\nYou may need to update both your build tool settings as well as your IDE.\n(See https://github.com/spring-projects/spring-framework/wiki/Spring-Framework-6.1-Release-Notes#parameter-name-retention)\n";

    MissingParameterNamesFailureAnalyzer() {
    }

    @Override
    public @Nullable FailureAnalysis analyze(Throwable failure) {
        return MissingParameterNamesFailureAnalyzer.analyzeForMissingParameters(failure);
    }

    static @Nullable FailureAnalysis analyzeForMissingParameters(Throwable failure) {
        return MissingParameterNamesFailureAnalyzer.analyzeForMissingParameters(failure, failure, new HashSet<Throwable>());
    }

    private static @Nullable FailureAnalysis analyzeForMissingParameters(Throwable rootFailure, @Nullable Throwable cause, Set<Throwable> seen) {
        if (cause != null && seen.add(cause)) {
            if (MissingParameterNamesFailureAnalyzer.isSpringParametersException(cause)) {
                return MissingParameterNamesFailureAnalyzer.getAnalysis(rootFailure, cause);
            }
            FailureAnalysis analysis = MissingParameterNamesFailureAnalyzer.analyzeForMissingParameters(rootFailure, cause.getCause(), seen);
            if (analysis != null) {
                return analysis;
            }
            for (Throwable suppressed : cause.getSuppressed()) {
                analysis = MissingParameterNamesFailureAnalyzer.analyzeForMissingParameters(rootFailure, suppressed, seen);
                if (analysis == null) continue;
                return analysis;
            }
        }
        return null;
    }

    private static boolean isSpringParametersException(Throwable failure) {
        String message = failure.getMessage();
        return message != null && message.contains(USE_PARAMETERS_MESSAGE) && MissingParameterNamesFailureAnalyzer.isSpringException(failure);
    }

    private static boolean isSpringException(Throwable failure) {
        StackTraceElement[] elements = failure.getStackTrace();
        return elements.length > 0 && MissingParameterNamesFailureAnalyzer.isSpringClass(elements[0].getClassName());
    }

    private static boolean isSpringClass(@Nullable String className) {
        return className != null && className.startsWith("org.springframework.");
    }

    private static FailureAnalysis getAnalysis(Throwable rootFailure, Throwable cause) {
        StringBuilder description = new StringBuilder(String.format("%s:%n", cause.getMessage()));
        if (rootFailure != cause) {
            description.append(String.format("%n    Resulting Failure: %s", MissingParameterNamesFailureAnalyzer.getExceptionTypeAndMessage(rootFailure)));
        }
        return new FailureAnalysis(description.toString(), ACTION, rootFailure);
    }

    private static String getExceptionTypeAndMessage(Throwable ex) {
        String message = ex.getMessage();
        return ex.getClass().getName() + (String)(StringUtils.hasText((String)message) ? ": " + message : "");
    }

    static void appendPossibility(StringBuilder description) {
        if (!description.toString().endsWith(System.lineSeparator())) {
            description.append("%n".formatted(new Object[0]));
        }
        description.append("%n%s".formatted(POSSIBILITY));
    }
}

