/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.LayeredLayout;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.boot.loader.tools.RepackagingLayout;

public final class Layouts {
    private Layouts() {
    }

    public static Layout forFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        String lowerCaseFileName = file.getName().toLowerCase(Locale.ENGLISH);
        if (lowerCaseFileName.endsWith(".jar")) {
            return new Jar();
        }
        if (lowerCaseFileName.endsWith(".war")) {
            return new War();
        }
        if (file.isDirectory() || lowerCaseFileName.endsWith(".zip")) {
            return new Expanded();
        }
        throw new IllegalStateException("Unable to deduce layout for '" + file + "'");
    }

    public static class War
    implements Layout {
        private static final Map<LibraryScope, String> SCOPE_LOCATION;

        @Override
        public String getLauncherClassName() {
            return "org.springframework.boot.loader.WarLauncher";
        }

        @Override
        public String getLibraryLocation(String libraryName, LibraryScope scope) {
            return SCOPE_LOCATION.get(scope);
        }

        @Override
        @Deprecated
        public String getLibraryDestination(String libraryName, LibraryScope scope) {
            return SCOPE_LOCATION.get(scope);
        }

        @Override
        public String getClassesLocation() {
            return "WEB-INF/classes/";
        }

        @Override
        public boolean isExecutable() {
            return true;
        }

        static {
            HashMap<LibraryScope, String> locations = new HashMap<LibraryScope, String>();
            locations.put(LibraryScope.COMPILE, "WEB-INF/lib/");
            locations.put(LibraryScope.CUSTOM, "WEB-INF/lib/");
            locations.put(LibraryScope.RUNTIME, "WEB-INF/lib/");
            locations.put(LibraryScope.PROVIDED, "WEB-INF/lib-provided/");
            SCOPE_LOCATION = Collections.unmodifiableMap(locations);
        }
    }

    public static class None
    extends Jar {
        @Override
        public String getLauncherClassName() {
            return null;
        }

        @Override
        public boolean isExecutable() {
            return false;
        }
    }

    public static class Expanded
    extends Jar {
        @Override
        public String getLauncherClassName() {
            return "org.springframework.boot.loader.PropertiesLauncher";
        }
    }

    public static class LayeredJar
    extends Jar
    implements LayeredLayout {
        @Override
        public String getLayersIndexFileLocation() {
            return "BOOT-INF/layers.idx";
        }

        @Override
        public String getRepackagedClassesLocation(Layer layer) {
            return "BOOT-INF/layers/" + layer + "/classes/";
        }

        @Override
        public String getLibraryLocation(String libraryName, LibraryScope scope, Layer layer) {
            return "BOOT-INF/layers/" + layer + "/lib/";
        }
    }

    public static class Jar
    implements RepackagingLayout {
        @Override
        public String getLauncherClassName() {
            return "org.springframework.boot.loader.JarLauncher";
        }

        @Override
        public String getLibraryLocation(String libraryName, LibraryScope scope) {
            return "BOOT-INF/lib/";
        }

        @Override
        @Deprecated
        public String getLibraryDestination(String libraryName, LibraryScope scope) {
            return "BOOT-INF/lib/";
        }

        @Override
        public String getClassesLocation() {
            return "";
        }

        @Override
        public String getRepackagedClassesLocation() {
            return "BOOT-INF/classes/";
        }

        @Override
        public String getClasspathIndexFileLocation() {
            return "BOOT-INF/classpath.idx";
        }

        @Override
        public boolean isExecutable() {
            return true;
        }
    }
}

