/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.util.Assert;

class JarModeLibrary
extends Library {
    static final JarModeLibrary LAYER_TOOLS = new JarModeLibrary("spring-boot-jarmode-layertools.jar");

    JarModeLibrary(String name) {
        super(name, null, LibraryScope.RUNTIME, false);
    }

    @Override
    InputStream openStream() throws IOException {
        String path = "META-INF/jarmode/" + this.getName();
        URL resource = this.getClass().getClassLoader().getResource(path);
        Assert.state((resource != null ? 1 : 0) != 0, (String)("Unable to find resource " + path));
        return resource.openStream();
    }

    @Override
    long getLastModified() {
        return 0L;
    }

    @Override
    public File getFile() {
        throw new UnsupportedOperationException("Unable to access jar mode library file");
    }
}

