/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.StandardLayers;

class ImplicitLayerResolver
extends StandardLayers {
    private static final String[] RESOURCE_LOCATIONS = new String[]{"META-INF/resources/", "resources/", "static/", "public/"};

    ImplicitLayerResolver() {
    }

    @Override
    public Layer getLayer(String name) {
        if (!this.isClassFile(name) && this.isInResourceLocation(name)) {
            return RESOURCES;
        }
        return APPLICATION;
    }

    @Override
    public Layer getLayer(Library library) {
        if (library.getName().contains("SNAPSHOT.")) {
            return SNAPSHOT_DEPENDENCIES;
        }
        return DEPENDENCIES;
    }

    private boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    private boolean isInResourceLocation(String name) {
        for (String resourceLocation : RESOURCE_LOCATIONS) {
            if (!name.startsWith(resourceLocation)) continue;
            return true;
        }
        return false;
    }
}

