/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.policy;

import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.context.RepeatContextCounter;
import org.springframework.batch.repeat.context.RepeatContextSupport;
import org.springframework.batch.repeat.policy.DefaultResultCompletionPolicy;

public abstract class CountingCompletionPolicy
extends DefaultResultCompletionPolicy {
    public static final String COUNT = CountingCompletionPolicy.class.getName() + ".COUNT";
    private boolean useParent = false;
    private int maxCount = 0;

    public void setUseParent(boolean useParent) {
        this.useParent = useParent;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    protected abstract int getCount(RepeatContext var1);

    protected int doUpdate(RepeatContext context) {
        return 0;
    }

    @Override
    public final boolean isComplete(RepeatContext context) {
        int count = ((CountingBatchContext)context).getCounter().getCount();
        return count >= this.maxCount;
    }

    @Override
    public RepeatContext start(RepeatContext parent) {
        return new CountingBatchContext(parent);
    }

    @Override
    public final void update(RepeatContext context) {
        super.update(context);
        int delta = this.doUpdate(context);
        ((CountingBatchContext)context).getCounter().increment(delta);
    }

    protected class CountingBatchContext
    extends RepeatContextSupport {
        RepeatContextCounter counter;

        public CountingBatchContext(RepeatContext parent) {
            super(parent);
            this.counter = new RepeatContextCounter(this, COUNT, CountingCompletionPolicy.this.useParent);
        }

        public RepeatContextCounter getCounter() {
            return this.counter;
        }
    }
}

