/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import java.util.Map;
import org.springframework.batch.item.database.Order;
import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryUtils;

public class OraclePagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    @Override
    public String generateFirstPageQuery(int pageSize) {
        return SqlPagingQueryUtils.generateRowNumSqlQuery(this, false, this.buildRowNumClause(pageSize));
    }

    @Override
    public String generateRemainingPagesQuery(int pageSize) {
        return SqlPagingQueryUtils.generateRowNumSqlQuery(this, true, this.buildRowNumClause(pageSize));
    }

    @Override
    public String generateJumpToItemQuery(int itemIndex, int pageSize) {
        int page = itemIndex / pageSize;
        int offset = page * pageSize;
        offset = offset == 0 ? 1 : offset;
        String sortKeySelect = this.getSortKeySelect();
        return SqlPagingQueryUtils.generateRowNumSqlQueryWithNesting(this, sortKeySelect, sortKeySelect, false, "TMP_ROW_NUM = " + offset);
    }

    private String getSortKeySelect() {
        StringBuilder sql = new StringBuilder();
        String prefix = "";
        for (Map.Entry<String, Order> sortKey : this.getSortKeys().entrySet()) {
            sql.append(prefix);
            prefix = ", ";
            sql.append(sortKey.getKey());
        }
        return sql.toString();
    }

    private String buildRowNumClause(int pageSize) {
        return "ROWNUM <= " + pageSize;
    }
}

