/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import spire.algebra.Sign;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.package$;
import spire.math.poly.BigDecimalRootRefinement;
import spire.math.poly.BigDecimalRootRefinement$AbsoluteContext$;
import spire.math.poly.BigDecimalRootRefinement$JBigDecimalOrder$;
import spire.math.poly.Term;
import spire.std.package$bigDecimal$;

public final class BigDecimalRootRefinement$
implements scala.Serializable {
    public static BigDecimalRootRefinement$ MODULE$;
    private final double spire$math$poly$BigDecimalRootRefinement$$bits2dec;

    static {
        new BigDecimalRootRefinement$();
    }

    public BigDecimalRootRefinement apply(Polynomial<scala.math.BigDecimal> poly, Rational lowerBound, Rational upperBound) {
        Polynomial<scala.math.BigDecimal> upoly = poly.map((Function1 & Serializable & scala.Serializable)n -> new scala.math.BigDecimal(n.bigDecimal(), MathContext.UNLIMITED), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(scala.math.BigDecimal.class), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra());
        return new BigDecimalRootRefinement(BigDecimalRootRefinement$AbsoluteContext$.MODULE$.apply(upoly, BigDecimalRootRefinement$AbsoluteContext$.MODULE$.apply$default$2()), new BigDecimalRootRefinement.Unbounded(lowerBound, upperBound));
    }

    public BigDecimalRootRefinement apply(Polynomial<scala.math.BigDecimal> poly, Rational lowerBound, Rational upperBound, int scale) {
        return this.apply(poly, lowerBound, upperBound).refine(scale);
    }

    public BigDecimalRootRefinement apply(Polynomial<scala.math.BigDecimal> poly, Rational lowerBound, Rational upperBound, MathContext mc) {
        return this.apply(poly, lowerBound, upperBound).refine(mc);
    }

    public double spire$math$poly$BigDecimalRootRefinement$$bits2dec() {
        return this.spire$math$poly$BigDecimalRootRefinement$$bits2dec;
    }

    public BigDecimalRootRefinement.Approximation spire$math$poly$BigDecimalRootRefinement$$QIR(BigDecimalRootRefinement.ApproximationContext context, Rational lowerBound, Rational upperBound, BigDecimal lb, BigDecimal ub) {
        return this.adjust$1(lb, (Option)None$.MODULE$, ub, (Option)None$.MODULE$, context, lowerBound, upperBound);
    }

    public BigDecimalRootRefinement.Approximation spire$math$poly$BigDecimalRootRefinement$$QIR(BigDecimalRootRefinement.ApproximationContext context, BigDecimal lowerBound, BigDecimal lowerBoundValue, BigDecimal upperBound, BigDecimal upperBoundValue, int n0) {
        if (n0 <= 0) {
            return this.loop0$1(lowerBound, lowerBoundValue, upperBound, upperBoundValue, context);
        }
        return this.loop$1(lowerBound, lowerBoundValue, upperBound, upperBoundValue, n0, context);
    }

    private int QIR$default$6() {
        return 0;
    }

    public BigDecimalRootRefinement apply(BigDecimalRootRefinement.ApproximationContext context, BigDecimalRootRefinement.Approximation approximation) {
        return new BigDecimalRootRefinement(context, approximation);
    }

    public Option<Tuple2<BigDecimalRootRefinement.ApproximationContext, BigDecimalRootRefinement.Approximation>> unapply(BigDecimalRootRefinement x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.context(), (Object)x$0.approximation()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Polynomial shift$1(Polynomial poly, Rational h) {
        int n = poly.degree();
        return poly.mapTerms((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(x0$1);
            }
            scala.math.BigDecimal a = scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(h.denominator().toBigInteger().pow(n - x0$1.exp())), MathContext.UNLIMITED);
            Term<scala.math.BigDecimal> term = new Term<scala.math.BigDecimal>(((scala.math.BigDecimal)x0$1.coeff()).$times(a), x0$1.exp());
            return term;
        }, package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(scala.math.BigDecimal.class), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).compose(Polynomial$.MODULE$.linear(scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(h.denominator().toBigInteger()), MathContext.UNLIMITED), scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(h.numerator().toBigInteger()), MathContext.UNLIMITED), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(scala.math.BigDecimal.class)), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).removeZeroRoots(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra());
    }

    private static final Polynomial mult$1(Polynomial poly, Rational s) {
        int n = poly.degree();
        return poly.mapTerms((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(x0$2);
            }
            scala.math.BigDecimal a = scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(s.denominator().toBigInteger().pow(n - x0$2.exp())), MathContext.UNLIMITED);
            Term<scala.math.BigDecimal> term = new Term<scala.math.BigDecimal>(((scala.math.BigDecimal)x0$2.coeff()).$times(a), x0$2.exp());
            return term;
        }, package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(scala.math.BigDecimal.class), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).compose(Polynomial$.MODULE$.linear(scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(s.numerator().toBigInteger()), MathContext.UNLIMITED), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), ClassTag$.MODULE$.apply(scala.math.BigDecimal.class)), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).removeZeroRoots(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra());
    }

    private static final boolean hasRoot$1(Rational l, Rational r, BigDecimalRootRefinement.ApproximationContext context$2) {
        if (!BoxesRunTime.equalsNumNum((Number)((Object)l), (Number)((Object)r))) {
            return BigDecimalRootRefinement$.mult$1(BigDecimalRootRefinement$.shift$1(context$2.poly(), l), r.$minus(l)).reciprocal(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).shift(BigDecimal$.MODULE$.int2bigDecimal(1), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).removeZeroRoots(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()).signVariations(package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra(), package$bigDecimal$.MODULE$.BigDecimalAlgebra()) % 2 == 1;
        }
        return false;
    }

    private static final Rational qlx$1(BigDecimal lx$1) {
        return Rational$.MODULE$.apply(new scala.math.BigDecimal(lx$1, MathContext.UNLIMITED));
    }

    private static final Rational qrx$1(BigDecimal rx$1) {
        return Rational$.MODULE$.apply(new scala.math.BigDecimal(rx$1, MathContext.UNLIMITED));
    }

    private final BigDecimalRootRefinement.Approximation adjust$1(BigDecimal lx, Option lyOpt, BigDecimal rx, Option ryOpt, BigDecimalRootRefinement.ApproximationContext context$2, Rational lowerBound$1, Rational upperBound$1) {
        while (lx.compareTo(rx) < 0) {
            if (lyOpt == null) {
                throw null;
            }
            Object object = lyOpt.isEmpty() ? context$2.evalExact(lx) : lyOpt.get();
            BigDecimal ly = (BigDecimal)object;
            if (ryOpt == null) {
                throw null;
            }
            Object object2 = ryOpt.isEmpty() ? context$2.evalExact(rx) : ryOpt.get();
            BigDecimal ry = (BigDecimal)object2;
            if (ly.signum() == 0) {
                if (BigDecimalRootRefinement$.qlx$1(lx).$greater((Object)lowerBound$1)) {
                    return new BigDecimalRootRefinement.ExactRoot(lx);
                }
                ryOpt = new Some((Object)ry);
                lyOpt = None$.MODULE$;
                lx = lx.add(BigDecimal.valueOf(1L, context$2.getEps(lx)));
                continue;
            }
            if (ry.signum() == 0) {
                if (BigDecimalRootRefinement$.qrx$1(rx).$less((Object)upperBound$1)) {
                    return new BigDecimalRootRefinement.ExactRoot(rx);
                }
                ryOpt = None$.MODULE$;
                rx = rx.subtract(BigDecimal.valueOf(1L, context$2.getEps(rx)));
                lyOpt = new Some((Object)ly);
                continue;
            }
            if (ry.signum() == ly.signum()) {
                if (BigDecimalRootRefinement$.hasRoot$1(lowerBound$1, BigDecimalRootRefinement$.qlx$1(lx), context$2)) {
                    return new BigDecimalRootRefinement.BoundedLeft(lowerBound$1, lx);
                }
                return new BigDecimalRootRefinement.BoundedRight(rx, upperBound$1);
            }
            return this.spire$math$poly$BigDecimalRootRefinement$$QIR(context$2, lx, ly, rx, ry, this.QIR$default$6());
        }
        return new BigDecimalRootRefinement.Unbounded(lowerBound$1, upperBound$1);
    }

    private final BigDecimalRootRefinement.Approximation loop$1(BigDecimal lx, BigDecimal ly, BigDecimal rx, BigDecimal ry, int n, BigDecimalRootRefinement.ApproximationContext context$1) {
        BigDecimal x1;
        block6: {
            BigDecimal x0;
            while (true) {
                Sign s0;
                Sign s1;
                int scale;
                BigDecimal eps;
                BigDecimal dx;
                if ((dx = rx.subtract(lx)).compareTo(eps = BigDecimal.valueOf(1L, scale = package$.MODULE$.max(context$1.getEps(lx), context$1.getEps(rx)))) <= 0) {
                    return new BigDecimalRootRefinement.Bounded(lx, ly, rx, ry, n);
                }
                BigDecimal dy = ly.subtract(ry);
                BigDecimal s = ly.divide(dy, n, RoundingMode.HALF_UP);
                BigDecimal delta = dx.multiply(s.ulp());
                BigInteger k = s.unscaledValue();
                x1 = lx.add(delta.multiply(new BigDecimal(k)));
                BigDecimal y1 = context$1.evalExact(x1);
                Sign sign = s1 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y1);
                Sign sign2 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(ly);
                if (!(sign != null ? !sign.equals(sign2) : sign2 != null)) {
                    Sign s2;
                    BigDecimal x2 = x1.add(delta);
                    BigDecimal y2 = context$1.evalExact(x2);
                    Sign sign3 = s2 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y2);
                    if (!(sign3 != null ? !sign3.equals(s1) : s1 != null)) {
                        return this.loop0$1(lx, ly, rx, ry, context$1);
                    }
                    Sign sign4 = s2;
                    Sign sign5 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(ry);
                    if (!(sign4 != null ? !sign4.equals(sign5) : sign5 != null)) {
                        n = 2 * n;
                        ry = y2;
                        rx = x2;
                        ly = y1;
                        lx = x1;
                        continue;
                    }
                    return new BigDecimalRootRefinement.ExactRoot(x2);
                }
                Sign sign6 = s1;
                Sign sign7 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(ry);
                if (sign6 != null ? !sign6.equals(sign7) : sign7 != null) break block6;
                x0 = x1.subtract(delta);
                BigDecimal y0 = context$1.evalExact(x0);
                Sign sign8 = s0 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y0);
                if (!(sign8 != null ? !sign8.equals(s1) : s1 != null)) {
                    return this.loop0$1(lx, ly, rx, ry, context$1);
                }
                Sign sign9 = s0;
                Sign sign10 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(ly);
                if (sign9 != null ? !sign9.equals(sign10) : sign10 != null) break;
                n = 2 * n;
                ry = y1;
                rx = x1;
                ly = y0;
                lx = x0;
            }
            return new BigDecimalRootRefinement.ExactRoot(x0);
        }
        return new BigDecimalRootRefinement.ExactRoot(x1);
    }

    private final BigDecimalRootRefinement.Approximation bisect$1(BigDecimal x0, BigDecimal y0, BigDecimal x1, BigDecimal y1, BigDecimal x2, BigDecimal y2, BigDecimalRootRefinement.ApproximationContext context$1) {
        if (y0.signum() == 0) {
            return new BigDecimalRootRefinement.ExactRoot(x0);
        }
        if (y1.signum() == 0) {
            return new BigDecimalRootRefinement.ExactRoot(x1);
        }
        if (y2.signum() == 0) {
            return new BigDecimalRootRefinement.ExactRoot(x2);
        }
        Sign sign = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y0);
        Sign sign2 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y1);
        if (sign == null ? sign2 != null : !sign.equals(sign2)) {
            return this.loop$1(x0, y0, x1, y1, 1, context$1);
        }
        return this.loop$1(x1, y1, x2, y2, 1, context$1);
    }

    private static final Tuple2 eval$1(int k, BigDecimalRootRefinement.ApproximationContext context$1, BigDecimal x0$3, BigDecimal eps$1) {
        BigDecimal x = new BigDecimal(k).multiply(eps$1).add(x0$3);
        BigDecimal y = context$1.evalExact(x);
        return new Tuple2((Object)x, (Object)y);
    }

    private final BigDecimalRootRefinement.Approximation loop0$1(BigDecimal x0, BigDecimal y0, BigDecimal x5, BigDecimal y5, BigDecimalRootRefinement.ApproximationContext context$1) {
        BigDecimal dy = y0.subtract(y5);
        int k = y0.divide(dy, 1, RoundingMode.HALF_UP).unscaledValue().intValue();
        BigDecimal eps = x5.subtract(x0).divide(new BigDecimal(5));
        if (k < 5) {
            Tuple2 tuple2 = BigDecimalRootRefinement$.eval$1(2, context$1, x0, eps);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object object = tuple2._2();
            Object object2 = tuple2._1();
            BigDecimal x2 = (BigDecimal)object2;
            BigDecimal y2 = (BigDecimal)object;
            Sign sign = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y2);
            Sign sign2 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y0);
            if (sign == null ? sign2 != null : !sign.equals(sign2)) {
                Tuple2 tuple22 = BigDecimalRootRefinement$.eval$1(1, context$1, x0, eps);
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                Object object3 = tuple22._2();
                Object object4 = tuple22._1();
                BigDecimal x1 = (BigDecimal)object4;
                BigDecimal y1 = (BigDecimal)object3;
                return this.bisect$1(x0, y0, x1, y1, x2, y2, context$1);
            }
            Tuple2 tuple23 = BigDecimalRootRefinement$.eval$1(3, context$1, x0, eps);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Object object5 = tuple23._2();
            Object object6 = tuple23._1();
            BigDecimal x3 = (BigDecimal)object6;
            BigDecimal y3 = (BigDecimal)object5;
            Sign sign3 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y3);
            Sign sign4 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y5);
            if (!(sign3 != null ? !sign3.equals(sign4) : sign4 != null)) {
                return this.loop$1(x2, y2, x3, y3, 1, context$1);
            }
            Tuple2 tuple24 = BigDecimalRootRefinement$.eval$1(4, context$1, x0, eps);
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Object object7 = tuple24._2();
            Object object8 = tuple24._1();
            BigDecimal x4 = (BigDecimal)object8;
            BigDecimal y4 = (BigDecimal)object7;
            return this.bisect$1(x3, y3, x4, y4, x5, y5, context$1);
        }
        Tuple2 tuple2 = BigDecimalRootRefinement$.eval$1(3, context$1, x0, eps);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object object = tuple2._2();
        Object object9 = tuple2._1();
        BigDecimal x3 = (BigDecimal)object9;
        BigDecimal y3 = (BigDecimal)object;
        Sign sign = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y3);
        Sign sign5 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y5);
        if (sign == null ? sign5 != null : !sign.equals(sign5)) {
            Tuple2 tuple25 = BigDecimalRootRefinement$.eval$1(4, context$1, x0, eps);
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            Object object10 = tuple25._2();
            Object object11 = tuple25._1();
            BigDecimal x4 = (BigDecimal)object11;
            BigDecimal y4 = (BigDecimal)object10;
            return this.bisect$1(x3, y3, x4, y4, x5, y5, context$1);
        }
        Tuple2 tuple26 = BigDecimalRootRefinement$.eval$1(2, context$1, x0, eps);
        if (tuple26 == null) {
            throw new MatchError((Object)tuple26);
        }
        Object object12 = tuple26._2();
        Object object13 = tuple26._1();
        BigDecimal x2 = (BigDecimal)object13;
        BigDecimal y2 = (BigDecimal)object12;
        Sign sign6 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y2);
        Sign sign7 = BigDecimalRootRefinement$JBigDecimalOrder$.MODULE$.sign(y0);
        if (!(sign6 != null ? !sign6.equals(sign7) : sign7 != null)) {
            return this.loop$1(x2, y2, x3, y3, 1, context$1);
        }
        Tuple2 tuple27 = BigDecimalRootRefinement$.eval$1(1, context$1, x0, eps);
        if (tuple27 == null) {
            throw new MatchError((Object)tuple27);
        }
        Object object14 = tuple27._2();
        Object object15 = tuple27._1();
        BigDecimal x1 = (BigDecimal)object15;
        BigDecimal y1 = (BigDecimal)object14;
        return this.bisect$1(x0, y0, x1, y1, x2, y2, context$1);
    }

    private BigDecimalRootRefinement$() {
        MODULE$ = this;
        this.spire$math$poly$BigDecimalRootRefinement$$bits2dec = package$.MODULE$.log(2.0, 10);
    }
}

