/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.reporting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.fix.NewInputFileEdit;
import org.sonar.api.batch.sensor.issue.fix.NewQuickFix;
import org.sonar.api.rule.RuleKey;
import org.sonar.java.Preconditions;
import org.sonar.java.SonarComponents;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaIssueBuilderExtended;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Tree;

public class InternalJavaIssueBuilder
implements JavaIssueBuilderExtended {
    private static final String RULE_NAME = "rule";
    private static final String TEXT_SPAN_NAME = "position";
    private static final String MESSAGE_NAME = "message";
    private static final String FLOWS_NAME = "flows";
    private static final String SECONDARIES_NAME = "secondaries";
    private static final Logger LOG = LoggerFactory.getLogger(InternalJavaIssueBuilder.class);
    private final InputFile inputFile;
    @Nullable
    private final SonarComponents sonarComponents;
    private final boolean isQuickFixCompatible;
    private final boolean isSetQuickFixAvailableCompatible;
    private JavaCheck rule;
    private AnalyzerMessage.TextSpan textSpan;
    private String message;
    @Nullable
    private List<JavaFileScannerContext.Location> secondaries;
    @Nullable
    private List<List<JavaFileScannerContext.Location>> flows;
    @Nullable
    private Integer cost;
    private final List<Supplier<List<JavaQuickFix>>> quickFixes = new ArrayList<Supplier<List<JavaQuickFix>>>();
    private boolean reported;

    public InternalJavaIssueBuilder(InputFile inputFile, @Nullable SonarComponents sonarComponents) {
        this.inputFile = inputFile;
        this.sonarComponents = sonarComponents;
        this.reported = false;
        this.isQuickFixCompatible = sonarComponents != null && sonarComponents.isQuickFixCompatible();
        this.isSetQuickFixAvailableCompatible = sonarComponents != null && sonarComponents.isSetQuickFixAvailableCompatible();
    }

    private static void requiresValueToBeSet(Object target, String targetName) {
        Preconditions.checkState(target != null, String.format("A %s must be set first.", targetName));
    }

    private static void requiresValueNotToBeSet(Object target, String targetName, String otherName) {
        Preconditions.checkState(target == null, String.format("Cannot set %s when %s is already set.", targetName, otherName));
    }

    private static void requiresSetOnlyOnce(Object target, String targetName) {
        Preconditions.checkState(target == null, String.format("Cannot set %s multiple times.", targetName));
    }

    @Override
    public final InternalJavaIssueBuilder forRule(JavaCheck rule) {
        InternalJavaIssueBuilder.requiresSetOnlyOnce(this.rule, RULE_NAME);
        this.rule = rule;
        return this;
    }

    @Override
    public final InternalJavaIssueBuilder onTree(Tree tree) {
        return this.onRange(AnalyzerMessage.textSpanFor(tree));
    }

    @Override
    public final InternalJavaIssueBuilder onRange(Tree from, Tree to) {
        return this.onRange(AnalyzerMessage.textSpanBetween(from, to));
    }

    private InternalJavaIssueBuilder onRange(AnalyzerMessage.TextSpan range) {
        InternalJavaIssueBuilder.requiresValueToBeSet(this.rule, RULE_NAME);
        InternalJavaIssueBuilder.requiresSetOnlyOnce(this.textSpan, TEXT_SPAN_NAME);
        this.textSpan = range;
        return this;
    }

    @Override
    public final InternalJavaIssueBuilder withMessage(String message) {
        InternalJavaIssueBuilder.requiresValueToBeSet(this.textSpan, TEXT_SPAN_NAME);
        InternalJavaIssueBuilder.requiresSetOnlyOnce(this.message, MESSAGE_NAME);
        this.message = message;
        return this;
    }

    @Override
    public final InternalJavaIssueBuilder withMessage(String message, Object ... args) {
        InternalJavaIssueBuilder.requiresValueToBeSet(this.textSpan, TEXT_SPAN_NAME);
        InternalJavaIssueBuilder.requiresSetOnlyOnce(this.message, MESSAGE_NAME);
        this.message = String.format(message, args);
        return this;
    }

    @Override
    public final InternalJavaIssueBuilder withSecondaries(JavaFileScannerContext.Location ... secondaries) {
        return this.withSecondaries((List)Arrays.asList(secondaries));
    }

    @Override
    public final InternalJavaIssueBuilder withSecondaries(List<JavaFileScannerContext.Location> secondaries) {
        InternalJavaIssueBuilder.requiresValueToBeSet(this.message, MESSAGE_NAME);
        InternalJavaIssueBuilder.requiresValueNotToBeSet(this.flows, FLOWS_NAME, SECONDARIES_NAME);
        InternalJavaIssueBuilder.requiresSetOnlyOnce(this.secondaries, SECONDARIES_NAME);
        this.secondaries = Collections.unmodifiableList(secondaries);
        return this;
    }

    @Override
    public final InternalJavaIssueBuilder withFlows(List<List<JavaFileScannerContext.Location>> flows) {
        InternalJavaIssueBuilder.requiresValueToBeSet(this.message, MESSAGE_NAME);
        InternalJavaIssueBuilder.requiresValueNotToBeSet(this.secondaries, SECONDARIES_NAME, FLOWS_NAME);
        InternalJavaIssueBuilder.requiresSetOnlyOnce(this.flows, FLOWS_NAME);
        this.flows = Collections.unmodifiableList(flows);
        return this;
    }

    @Override
    public final InternalJavaIssueBuilder withCost(int cost) {
        InternalJavaIssueBuilder.requiresValueToBeSet(this.message, MESSAGE_NAME);
        InternalJavaIssueBuilder.requiresSetOnlyOnce(this.cost, "cost");
        this.cost = cost;
        return this;
    }

    @Override
    public final InternalJavaIssueBuilder withQuickFix(Supplier<JavaQuickFix> quickFix) {
        InternalJavaIssueBuilder.requiresValueToBeSet(this.message, MESSAGE_NAME);
        this.quickFixes.add(() -> Collections.singletonList((JavaQuickFix)quickFix.get()));
        return this;
    }

    @Override
    public final InternalJavaIssueBuilder withQuickFixes(Supplier<List<JavaQuickFix>> quickFixes) {
        InternalJavaIssueBuilder.requiresValueToBeSet(this.message, MESSAGE_NAME);
        this.quickFixes.add(quickFixes);
        return this;
    }

    @Override
    public void report() {
        Preconditions.checkState(!this.reported, "Can only be reported once.");
        InternalJavaIssueBuilder.requiresValueToBeSet(this.rule, RULE_NAME);
        InternalJavaIssueBuilder.requiresValueToBeSet(this.textSpan, TEXT_SPAN_NAME);
        InternalJavaIssueBuilder.requiresValueToBeSet(this.message, MESSAGE_NAME);
        if (this.sonarComponents == null) {
            LOG.trace("SonarComponents is not set - discarding issue");
            return;
        }
        Optional<RuleKey> ruleKey = this.sonarComponents.getRuleKey(this.rule);
        if (!ruleKey.isPresent()) {
            LOG.trace("Rule not enabled - discarding issue");
            return;
        }
        RuleKey ruleKeyVal = ruleKey.get();
        NewIssue newIssue = this.sonarComponents.context().newIssue().forRule(ruleKeyVal).gap(Double.valueOf(this.cost == null ? 0.0 : this.cost.doubleValue()));
        newIssue.at(newIssue.newLocation().on((InputComponent)this.inputFile).at(this.inputFile.newRange(this.textSpan.startLine, this.textSpan.startCharacter, this.textSpan.endLine, this.textSpan.endCharacter)).message(this.message));
        if (this.secondaries != null) {
            this.flows = this.secondaries.stream().map(Collections::singletonList).collect(Collectors.toList());
            this.secondaries = null;
        }
        if (this.flows != null) {
            for (List<JavaFileScannerContext.Location> flow : this.flows) {
                newIssue.addFlow((Iterable)flow.stream().map(location -> newIssue.newLocation().on((InputComponent)this.inputFile).at(InternalJavaIssueBuilder.range(this.inputFile, location)).message(location.msg)).collect(Collectors.toList()));
            }
        }
        this.handleQuickFixes(ruleKeyVal, newIssue);
        newIssue.save();
        this.reported = true;
    }

    private void handleQuickFixes(RuleKey ruleKey, NewIssue newIssue) {
        if (this.quickFixes.isEmpty() || !this.isQuickFixCompatible && !this.isSetQuickFixAvailableCompatible) {
            return;
        }
        List<JavaQuickFix> flatQuickFixes = this.quickFixes.stream().flatMap(s -> ((List)s.get()).stream()).collect(Collectors.toList());
        if (flatQuickFixes.isEmpty()) {
            return;
        }
        if (this.isQuickFixCompatible) {
            InternalJavaIssueBuilder.addQuickFixes(this.inputFile, ruleKey, flatQuickFixes, newIssue);
        } else {
            newIssue.setQuickFixAvailable(true);
        }
    }

    private static void addQuickFixes(InputFile inputFile, RuleKey ruleKey, Iterable<JavaQuickFix> quickFixes, NewIssue sonarLintIssue) {
        try {
            for (JavaQuickFix quickFix : quickFixes) {
                NewQuickFix newQuickFix = sonarLintIssue.newQuickFix().message(quickFix.getDescription());
                NewInputFileEdit edit = newQuickFix.newInputFileEdit().on(inputFile);
                quickFix.getTextEdits().stream().map(javaTextEdit -> edit.newTextEdit().at(InternalJavaIssueBuilder.rangeFromTextSpan(inputFile, javaTextEdit.getTextSpan())).withNewText(javaTextEdit.getReplacement())).forEach(arg_0 -> ((NewInputFileEdit)edit).addTextEdit(arg_0));
                newQuickFix.addInputFileEdit(edit);
                sonarLintIssue.addQuickFix(newQuickFix);
            }
        }
        catch (RuntimeException e) {
            LOG.warn(String.format("Could not report quick fixes for rule: %s. %s: %s", ruleKey, e.getClass().getName(), e.getMessage()));
        }
    }

    private static TextRange range(InputFile file, JavaFileScannerContext.Location location) {
        return InternalJavaIssueBuilder.rangeFromTextSpan(file, AnalyzerMessage.textSpanFor(location.syntaxNode));
    }

    private static TextRange rangeFromTextSpan(InputFile file, AnalyzerMessage.TextSpan textSpan) {
        return file.newRange(textSpan.startLine, textSpan.startCharacter, textSpan.endLine, textSpan.endCharacter);
    }

    public JavaCheck rule() {
        return this.rule;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    public String message() {
        return this.message;
    }

    public AnalyzerMessage.TextSpan textSpan() {
        return this.textSpan;
    }

    public Optional<Integer> cost() {
        return Optional.ofNullable(this.cost);
    }

    public Optional<List<JavaFileScannerContext.Location>> secondaries() {
        return Optional.ofNullable(this.secondaries);
    }

    public Optional<List<List<JavaFileScannerContext.Location>>> flows() {
        return Optional.ofNullable(this.flows);
    }

    public List<Supplier<List<JavaQuickFix>>> quickFixes() {
        return this.quickFixes;
    }
}

