/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public class WhileStatementTreeImpl
extends JavaTree
implements WhileStatementTree {
    private final ExpressionTree condition;
    private final StatementTree statement;
    private final InternalSyntaxToken whileKeyword;
    private final InternalSyntaxToken openParenToken;
    private final InternalSyntaxToken closeParenToken;

    public WhileStatementTreeImpl(InternalSyntaxToken whileKeyword, InternalSyntaxToken openParenToken, ExpressionTree condition, InternalSyntaxToken closeParenToken, StatementTree statement) {
        this.whileKeyword = whileKeyword;
        this.openParenToken = openParenToken;
        this.condition = Objects.requireNonNull(condition);
        this.closeParenToken = closeParenToken;
        this.statement = Objects.requireNonNull(statement);
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.WHILE_STATEMENT;
    }

    @Override
    public SyntaxToken whileKeyword() {
        return this.whileKeyword;
    }

    @Override
    public SyntaxToken openParenToken() {
        return this.openParenToken;
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return this.closeParenToken;
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitWhileStatement(this);
    }

    @Override
    public List<Tree> children() {
        return Arrays.asList(this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement);
    }
}

