/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.java.Preconditions;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;

public class NewArrayTreeImpl
extends AssessableExpressionTree
implements NewArrayTree {
    @Nullable
    private TypeTree type = null;
    @Nullable
    private SyntaxToken newKeyword;
    private List<ArrayDimensionTree> dimensions;
    @Nullable
    private SyntaxToken openCurlyBraceToken;
    private final ListTree<ExpressionTree> initializers;
    @Nullable
    private SyntaxToken closeCurlyBraceToken;

    public NewArrayTreeImpl(List<ArrayDimensionTree> dimensions, ListTree<ExpressionTree> initializers) {
        this.dimensions = Objects.requireNonNull(dimensions);
        this.initializers = Objects.requireNonNull(initializers);
    }

    public NewArrayTreeImpl complete(TypeTree type) {
        Preconditions.checkState(this.type == null);
        this.type = type;
        return this;
    }

    public NewArrayTreeImpl completeWithNewKeyword(SyntaxToken newKeyword) {
        this.newKeyword = newKeyword;
        return this;
    }

    public NewArrayTreeImpl completeWithCurlyBraces(SyntaxToken openCurlyBraceToken, SyntaxToken closeCurlyBraceToken) {
        this.openCurlyBraceToken = openCurlyBraceToken;
        this.closeCurlyBraceToken = closeCurlyBraceToken;
        return this;
    }

    public NewArrayTreeImpl completeDimensions(List<ArrayDimensionTree> arrayDimensions) {
        this.dimensions = Stream.of(arrayDimensions, this.dimensions).flatMap(Collection::stream).collect(Collectors.toList());
        return this;
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.NEW_ARRAY;
    }

    @Override
    public TypeTree type() {
        return this.type;
    }

    @Override
    public List<ArrayDimensionTree> dimensions() {
        return this.dimensions;
    }

    @Override
    @Nullable
    public SyntaxToken openBraceToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    public ListTree<ExpressionTree> initializers() {
        return this.initializers;
    }

    @Override
    @Nullable
    public SyntaxToken closeBraceToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitNewArray(this);
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> list = new ArrayList<Tree>();
        NewArrayTreeImpl.addIfNotNull(list, this.newKeyword);
        NewArrayTreeImpl.addIfNotNull(list, this.type);
        list.addAll(this.dimensions);
        NewArrayTreeImpl.addIfNotNull(list, this.openCurlyBraceToken);
        list.add(this.initializers);
        NewArrayTreeImpl.addIfNotNull(list, this.closeCurlyBraceToken);
        return Collections.unmodifiableList(list);
    }

    @Override
    public SyntaxToken newKeyword() {
        return this.newKeyword;
    }

    private static List<Tree> addIfNotNull(List<Tree> list, @Nullable Tree tree) {
        if (tree != null) {
            list.add(tree);
        }
        return list;
    }
}

