/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

public class LiteralUtils {
    private LiteralUtils() {
    }

    @CheckForNull
    public static Integer intLiteralValue(ExpressionTree expression) {
        if (expression.is(Tree.Kind.INT_LITERAL)) {
            return LiteralUtils.intLiteralValue((LiteralTree)expression);
        }
        if (expression.is(Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS)) {
            UnaryExpressionTree unaryExp = (UnaryExpressionTree)expression;
            Integer subExpressionIntValue = LiteralUtils.intLiteralValue(unaryExp.expression());
            return expression.is(Tree.Kind.UNARY_MINUS) ? LiteralUtils.minus(subExpressionIntValue) : subExpressionIntValue;
        }
        return null;
    }

    private static Integer intLiteralValue(LiteralTree literal) {
        String literalValue = literal.value().replace("_", "");
        if (literalValue.startsWith("0b") || literalValue.startsWith("0B")) {
            return Integer.parseUnsignedInt(literalValue.substring(2), 2);
        }
        return Long.decode(literalValue).intValue();
    }

    @CheckForNull
    public static Long longLiteralValue(ExpressionTree tree) {
        int sign;
        ExpressionTree expression = tree;
        int n = sign = tree.is(Tree.Kind.UNARY_MINUS) ? -1 : 1;
        if (tree.is(Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS)) {
            expression = ((UnaryExpressionTree)tree).expression();
        }
        if (expression.is(Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL)) {
            String value = LiteralUtils.trimLongSuffix(((LiteralTree)expression).value());
            value = value.replace("_", "");
            try {
                if (value.startsWith("0b") || value.startsWith("0B")) {
                    return (long)sign * Long.valueOf(value.substring(2), 2);
                }
                return (long)sign * Long.decode(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @CheckForNull
    private static Integer minus(@Nullable Integer nullableInteger) {
        return nullableInteger == null ? null : Integer.valueOf(-nullableInteger.intValue());
    }

    public static boolean isEmptyString(Tree tree) {
        return tree.is(Tree.Kind.STRING_LITERAL) && LiteralUtils.trimQuotes(((LiteralTree)tree).value()).isEmpty();
    }

    public static boolean is0xff(ExpressionTree expression) {
        return expression.is(Tree.Kind.INT_LITERAL) && "0xff".equalsIgnoreCase(((LiteralTree)expression).value());
    }

    public static String trimQuotes(String value) {
        int delimiterLength = LiteralUtils.isTextBlock(value) ? 3 : 1;
        return value.substring(delimiterLength, value.length() - delimiterLength);
    }

    public static boolean isTextBlock(String value) {
        return value.startsWith("\"\"\"");
    }

    public static String trimLongSuffix(String longString) {
        if (StringUtils.isBlank((CharSequence)longString)) {
            return longString;
        }
        int lastCharPosition = longString.length() - 1;
        char lastChar = longString.charAt(lastCharPosition);
        String value = longString;
        if (lastChar == 'L' || lastChar == 'l') {
            value = longString.substring(0, lastCharPosition);
        }
        return value;
    }

    public static boolean hasValue(Tree tree, String expectedValue) {
        if (!tree.is(Tree.Kind.STRING_LITERAL)) {
            return false;
        }
        String actualValue = LiteralUtils.trimQuotes(((LiteralTree)tree).value());
        return expectedValue.equals(actualValue);
    }

    public static boolean isTrue(Tree tree) {
        return tree.is(Tree.Kind.BOOLEAN_LITERAL) && "true".equals(((LiteralTree)tree).value());
    }

    public static boolean isFalse(Tree tree) {
        return tree.is(Tree.Kind.BOOLEAN_LITERAL) && "false".equals(((LiteralTree)tree).value());
    }

    public static boolean isZero(ExpressionTree tree) {
        return tree.is(Tree.Kind.INT_LITERAL) && "0".equals(((LiteralTree)tree).value());
    }

    public static boolean isOne(ExpressionTree tree) {
        return tree.is(Tree.Kind.INT_LITERAL) && "1".equals(((LiteralTree)tree).value());
    }

    public static boolean isNegOne(ExpressionTree tree) {
        return tree.is(Tree.Kind.UNARY_MINUS) && LiteralUtils.isOne(((UnaryExpressionTree)tree).expression());
    }

    public static String getAsStringValue(LiteralTree tree) {
        if (!tree.is(Tree.Kind.TEXT_BLOCK)) {
            return tree.is(Tree.Kind.STRING_LITERAL) ? LiteralUtils.trimQuotes(tree.value()) : tree.value();
        }
        String[] lines = tree.value().split("\r?\n");
        int indent = LiteralUtils.indentationOfTextBlock(lines);
        return Arrays.stream(lines).skip(1L).map(String::stripTrailing).map(s -> LiteralUtils.stripIndent(indent, s)).collect(Collectors.joining("\n")).replaceAll("\"\"\"$", "");
    }

    private static String stripIndent(int indent, String s) {
        return s.isEmpty() ? s : s.substring(indent);
    }

    public static int indentationOfTextBlock(String[] lines) {
        return Arrays.stream(lines).skip(1L).filter(LiteralUtils::isNonEmptyLine).mapToInt(LiteralUtils::getIndentation).min().orElse(0);
    }

    private static boolean isNonEmptyLine(String line) {
        return line.chars().anyMatch(LiteralUtils::isNotWhiteSpace);
    }

    private static boolean isNotWhiteSpace(int c) {
        return c != 32 && c != 9 && c != 12;
    }

    private static int getIndentation(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (!LiteralUtils.isNotWhiteSpace(line.charAt(i))) continue;
            return i;
        }
        return line.length();
    }
}

