/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.List;
import javax.annotation.Nonnull;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.location.InternalPosition;
import org.sonar.plugins.java.api.location.Range;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

public class InternalSyntaxTrivia
extends JavaTree
implements SyntaxTrivia {
    private final String comment;
    @Nonnull
    private final Range range;

    public InternalSyntaxTrivia(String comment, int line, int columnOffset) {
        this.comment = comment;
        this.range = comment.startsWith("/*") ? Range.at(InternalPosition.atOffset(line, columnOffset), comment) : Range.at(InternalPosition.atOffset(line, columnOffset), comment.length());
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public int startLine() {
        return this.range.start().line();
    }

    @Override
    public Tree.Kind kind() {
        return Tree.Kind.TRIVIA;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public List<Tree> children() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(TreeVisitor visitor) {
    }

    public static SyntaxTrivia create(String comment, int startLine, int column) {
        return new InternalSyntaxTrivia(comment, startLine, column);
    }

    @Override
    public int getLine() {
        return this.range.start().line();
    }

    @Override
    public int column() {
        return this.range.start().columnOffset();
    }

    @Override
    @Nonnull
    public Range range() {
        return this.range;
    }
}

