/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.metrics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.ast.visitors.CognitiveComplexityVisitor;
import org.sonar.java.ast.visitors.CommentLinesVisitor;
import org.sonar.java.ast.visitors.ComplexityVisitor;
import org.sonar.java.ast.visitors.LinesOfCodeVisitor;
import org.sonar.java.ast.visitors.MethodNestingLevelVisitor;
import org.sonar.java.ast.visitors.NumberOfAccessedVariablesVisitor;
import org.sonar.java.ast.visitors.StatementVisitor;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

public class MetricsComputer {
    private final Map<Integer, List<Tree>> methodComplexityNodes = new HashMap<Integer, List<Tree>>();
    private final Map<Integer, CognitiveComplexityVisitor.Result> methodComplexity = new HashMap<Integer, CognitiveComplexityVisitor.Result>();
    private final Map<Integer, Integer> compilationUnityComplexity = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> methodNumberOfAccessedVariables = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> treeLinesOfCode = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> treeNumberOfStatements = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> treeNumberOfCommentedLines = new HashMap<Integer, Integer>();
    private final Map<Integer, Set<Integer>> treeNoSonarLines = new HashMap<Integer, Set<Integer>>();
    private final Map<Integer, Integer> methodNestingLevel = new HashMap<Integer, Integer>();
    ComplexityVisitor complexityVisitor = new ComplexityVisitor();
    NumberOfAccessedVariablesVisitor methodBodyVisitor = new NumberOfAccessedVariablesVisitor();
    LinesOfCodeVisitor linesOfCodeVisitor = new LinesOfCodeVisitor();
    StatementVisitor numberOfStatementsVisitor = new StatementVisitor();
    CommentLinesVisitor commentedLineVisitor = new CommentLinesVisitor();
    MethodNestingLevelVisitor methodNestingVisitor = new MethodNestingLevelVisitor();

    public List<Tree> getComplexityNodes(Tree tree) {
        return this.methodComplexityNodes.computeIfAbsent(tree.hashCode(), k -> this.complexityVisitor.getNodes(tree));
    }

    public CognitiveComplexityVisitor.Result getMethodComplexity(MethodTree tree) {
        return this.methodComplexity.computeIfAbsent(tree.hashCode(), k -> CognitiveComplexityVisitor.methodComplexity(tree));
    }

    public int getNumberOfAccessedVariables(MethodTree tree) {
        return this.methodNumberOfAccessedVariables.computeIfAbsent(tree.hashCode(), k -> this.methodBodyVisitor.getNumberOfAccessedVariables(tree));
    }

    public int getLinesOfCode(Tree tree) {
        return this.treeLinesOfCode.computeIfAbsent(tree.hashCode(), k -> this.linesOfCodeVisitor.linesOfCode(tree));
    }

    public int getNumberOfStatements(Tree tree) {
        return this.treeNumberOfStatements.computeIfAbsent(tree.hashCode(), k -> this.numberOfStatementsVisitor.numberOfStatements(tree));
    }

    public Integer getNumberOfCommentedLines(CompilationUnitTree tree) {
        return this.treeNumberOfCommentedLines.computeIfAbsent(tree.hashCode(), k -> {
            this.commentedLineVisitor.analyzeCommentLines(tree);
            return this.commentedLineVisitor.commentLinesMetric();
        });
    }

    public Set<Integer> getNoSonarLines(CompilationUnitTree tree) {
        return this.treeNoSonarLines.computeIfAbsent(tree.hashCode(), k -> {
            this.commentedLineVisitor.analyzeCommentLines(tree);
            return this.commentedLineVisitor.noSonarLines();
        });
    }

    public int getCompilationUnitComplexity(CompilationUnitTree tree) {
        return this.compilationUnityComplexity.computeIfAbsent(tree.hashCode(), k -> CognitiveComplexityVisitor.compilationUnitComplexity(tree));
    }

    public int getMethodNestingLevel(MethodTree tree) {
        return this.methodNestingLevel.computeIfAbsent(tree.hashCode(), k -> this.methodNestingVisitor.getMaxNestingLevel(tree));
    }

    @VisibleForTesting
    Map<Integer, List<Tree>> getMethodComplexityNodes() {
        return this.methodComplexityNodes;
    }

    @VisibleForTesting
    Map<Integer, CognitiveComplexityVisitor.Result> getMethodComplexity() {
        return this.methodComplexity;
    }

    @VisibleForTesting
    Map<Integer, Integer> getCompilationUnityComplexity() {
        return this.compilationUnityComplexity;
    }

    @VisibleForTesting
    Map<Integer, Integer> getMethodNumberOfAccessedVariables() {
        return this.methodNumberOfAccessedVariables;
    }

    @VisibleForTesting
    Map<Integer, Integer> getTreeLinesOfCode() {
        return this.treeLinesOfCode;
    }

    @VisibleForTesting
    Map<Integer, Integer> getTreeNumberOfStatements() {
        return this.treeNumberOfStatements;
    }

    @VisibleForTesting
    Map<Integer, Integer> getTreeNumberOfCommentedLines() {
        return this.treeNumberOfCommentedLines;
    }

    @VisibleForTesting
    Map<Integer, Set<Integer>> getTreeNoSonarLines() {
        return this.treeNoSonarLines;
    }

    @VisibleForTesting
    Map<Integer, Integer> getMethodNestingLevel() {
        return this.methodNestingLevel;
    }
}

