/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5977")
public class RandomizedTestDataCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers RANDOM_CONSTRUCTOR_METHOD_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.util.Random"}).constructor().withAnyParameters().build();
    private static final MethodMatchers RANDOM_UUID_MATCHER = MethodMatchers.create().ofTypes(new String[]{"java.util.UUID"}).names(new String[]{"randomUUID"}).addWithoutParametersMatcher().build();
    private static final String LOCATIONS_TEXT = "usage of random data in test";
    private static final String MESSAGE = "Replace randomly generated values with fixed ones.";
    private final List<Tree> randomSecondaryLocations = new ArrayList<Tree>();
    private final List<Tree> randomUUIDSecondaryLocations = new ArrayList<Tree>();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            NewClassTree newClassTree = (NewClassTree)tree;
            this.checkForRandomConstructorUsage(newClassTree);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
            this.checkUUIDRandomUsage(methodInvocationTree);
        }
    }

    private void checkForRandomConstructorUsage(NewClassTree newClassTree) {
        if (RANDOM_CONSTRUCTOR_METHOD_MATCHER.matches(newClassTree)) {
            this.randomSecondaryLocations.add((Tree)newClassTree);
        }
    }

    private void checkUUIDRandomUsage(MethodInvocationTree methodInvocationTree) {
        if (RANDOM_UUID_MATCHER.matches(methodInvocationTree)) {
            this.randomUUIDSecondaryLocations.add((Tree)methodInvocationTree);
        }
    }

    public void leaveFile(JavaFileScannerContext context) {
        if (!this.randomSecondaryLocations.isEmpty()) {
            this.reportIssue(this.randomSecondaryLocations.get(0), MESSAGE, RandomizedTestDataCheck.convertToLocations(this.randomSecondaryLocations.stream().skip(1L)), null);
        }
        if (!this.randomUUIDSecondaryLocations.isEmpty()) {
            this.reportIssue(this.randomUUIDSecondaryLocations.get(0), MESSAGE, RandomizedTestDataCheck.convertToLocations(this.randomUUIDSecondaryLocations.stream().skip(1L)), null);
        }
        this.cleanup();
        super.leaveFile(context);
    }

    private void cleanup() {
        this.randomSecondaryLocations.clear();
        this.randomUUIDSecondaryLocations.clear();
    }

    private static List<JavaFileScannerContext.Location> convertToLocations(Stream<Tree> trees) {
        return trees.map(tree -> new JavaFileScannerContext.Location(LOCATIONS_TEXT, tree)).collect(Collectors.toList());
    }
}

