/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6804")
public class ValueAnnotationShouldInjectPropertyOrSpELCheck
extends IssuableSubscriptionVisitor {
    private static final String SPRING_VALUE = "org.springframework.beans.factory.annotation.Value";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS, Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        ClassTree cls = (ClassTree)tree;
        List fieldsAnnotations = cls.members().stream().filter(m -> m.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).flatMap(field -> ((VariableTree)field).modifiers().annotations().stream()).collect(Collectors.toList());
        List interfaceAnnotations = cls.is(new Tree.Kind[]{Tree.Kind.ANNOTATION_TYPE}) ? cls.modifiers().annotations() : List.of();
        Stream.concat(fieldsAnnotations.stream(), interfaceAnnotations.stream()).filter(ValueAnnotationShouldInjectPropertyOrSpELCheck::isSimpleSpringValue).forEach(ann -> this.reportIssue((Tree)ann, "Either replace the \"@Value\" annotation with a standard field initialization, use \"${propertyName}\" to inject a property or use \"#{expression}\" to evaluate a SpEL expression."));
    }

    private static boolean isSimpleSpringValue(AnnotationTree annotation) {
        if (annotation.symbolType().is(SPRING_VALUE)) {
            String value = ValueAnnotationShouldInjectPropertyOrSpELCheck.extractArgumentValue((ExpressionTree)annotation.arguments().get(0));
            return value != null && !ValueAnnotationShouldInjectPropertyOrSpELCheck.isPropertyName(value) && !ValueAnnotationShouldInjectPropertyOrSpELCheck.isSpEL(value);
        }
        return false;
    }

    @CheckForNull
    private static String extractArgumentValue(ExpressionTree annotationArgument) {
        if (annotationArgument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            ExpressionTree expression = ((AssignmentExpressionTree)annotationArgument).expression();
            return ExpressionsHelper.getConstantValueAsString(expression).value();
        }
        return ExpressionsHelper.getConstantValueAsString(annotationArgument).value();
    }

    private static boolean isPropertyName(String value) {
        return value.startsWith("${") && value.endsWith("}");
    }

    private static boolean isSpEL(String value) {
        return value.startsWith("#{") && value.endsWith("}");
    }
}

