/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.QuickFixHelper;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S6816")
public class NullableInjectedFieldsHaveDefaultValueCheck
extends IssuableSubscriptionVisitor {
    private static final String VALUE_ANNOTATION = "org.springframework.beans.factory.annotation.Value";
    private static final String MESSAGE_FOR_FIELDS = "Provide a default null value for this field.";
    private static final String MESSAGE_FOR_PARAMETERS = "Provide a default null value for this parameter.";

    public List<Tree.Kind> nodesToVisit() {
        return List.of(Tree.Kind.CLASS, Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        Stream<Object> variables;
        AnnotationTree methodLevelValueAnnotation;
        boolean isClass = tree.is(new Tree.Kind[]{Tree.Kind.CLASS});
        if (isClass) {
            methodLevelValueAnnotation = null;
            variables = ((ClassTree)tree).members().stream().filter(member -> member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})).map(VariableTree.class::cast);
        } else {
            MethodTree method = (MethodTree)tree;
            variables = method.parameters().stream();
            methodLevelValueAnnotation = NullableInjectedFieldsHaveDefaultValueCheck.extractValueAnnotationOnSetter(method);
        }
        String issueMessage = isClass ? MESSAGE_FOR_FIELDS : MESSAGE_FOR_PARAMETERS;
        variables.map(variable -> NullableInjectedFieldsHaveDefaultValueCheck.mapToAnnotationsOfInterest(variable, methodLevelValueAnnotation)).filter(Optional::isPresent).map(Optional::get).forEach(trees -> QuickFixHelper.newIssue(this.context).forRule((JavaCheck)this).onTree((Tree)trees.valueAnnotation).withMessage(issueMessage).withSecondaries(new JavaFileScannerContext.Location[]{new JavaFileScannerContext.Location("The nullable annotation", (Tree)trees.nullableAnnotation)}).withQuickFixes(() -> NullableInjectedFieldsHaveDefaultValueCheck.computeQuickFix(trees.valueAnnotation)).report());
    }

    private static List<JavaQuickFix> computeQuickFix(AnnotationTree annotation) {
        ExpressionTree expression = NullableInjectedFieldsHaveDefaultValueCheck.extractExpressionTree((ExpressionTree)annotation.arguments().get(0));
        ArrayList<JavaQuickFix> quickFixes = new ArrayList<JavaQuickFix>(2);
        String originalValue = ExpressionsHelper.getConstantValueAsString(expression).value();
        if (originalValue == null) {
            return List.of();
        }
        String currentValue = originalValue.strip();
        String replacementValue = "\"" + originalValue.strip().substring(0, currentValue.lastIndexOf(125)) + ":#{null}}\"";
        String quickFixMessage = "Set null as default value";
        if (!expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            quickFixMessage = "Set null as default value locally";
            NullableInjectedFieldsHaveDefaultValueCheck.computeQuickFixOnOriginalDefinition(expression, replacementValue).ifPresent(quickFixes::add);
        }
        quickFixes.add(JavaQuickFix.newQuickFix((String)quickFixMessage).addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)expression, (String)replacementValue)}).build());
        return quickFixes;
    }

    private static Optional<JavaQuickFix> computeQuickFixOnOriginalDefinition(ExpressionTree expression, String replacementValue) {
        ExpressionTree assignedExpression;
        Symbol symbol = expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? ((MemberSelectExpressionTree)expression).identifier().symbol() : ((IdentifierTree)expression).symbol();
        Tree declaration = symbol.declaration();
        if (declaration != null && declaration.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && (assignedExpression = ((VariableTree)declaration).initializer()) != null) {
            return Optional.of(JavaQuickFix.newQuickFix((String)"Set null as default value").addTextEdit(new JavaTextEdit[]{JavaTextEdit.replaceTree((Tree)assignedExpression, (String)replacementValue)}).build());
        }
        return Optional.empty();
    }

    private static Optional<AnnotationsOfInterest> mapToAnnotationsOfInterest(VariableTree variable, @Nullable AnnotationTree valueAnnotationOnParent) {
        AnnotationTree valueAnnotation;
        if (valueAnnotationOnParent == null) {
            Optional<AnnotationTree> annotationOnVariable = NullableInjectedFieldsHaveDefaultValueCheck.getValueAnnotationWithoutDefault(variable);
            if (annotationOnVariable.isEmpty()) {
                return Optional.empty();
            }
            valueAnnotation = annotationOnVariable.get();
        } else {
            valueAnnotation = valueAnnotationOnParent;
        }
        Optional<AnnotationTree> nullableAnnotation = NullableInjectedFieldsHaveDefaultValueCheck.getNullableAnnotation(variable);
        return nullableAnnotation.map(annotationTree -> new AnnotationsOfInterest(valueAnnotation, (AnnotationTree)annotationTree));
    }

    @Nullable
    private static AnnotationTree extractValueAnnotationOnSetter(MethodTree method) {
        if (MethodTreeUtils.isSetterMethod(method)) {
            return method.modifiers().annotations().stream().filter(annotation -> annotation.symbolType().is(VALUE_ANNOTATION) && !NullableInjectedFieldsHaveDefaultValueCheck.hasDefaultValue(annotation)).findFirst().orElse(null);
        }
        return null;
    }

    private static Optional<AnnotationTree> getNullableAnnotation(VariableTree field) {
        SymbolMetadata.NullabilityData nullabilityData = field.symbol().metadata().nullabilityData(SymbolMetadata.NullabilityTarget.FIELD);
        SymbolMetadata.AnnotationInstance instance = nullabilityData.annotation();
        if (instance == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(field.symbol().metadata().findAnnotationTree(instance));
    }

    private static Optional<AnnotationTree> getValueAnnotationWithoutDefault(VariableTree field) {
        return field.modifiers().annotations().stream().filter(annotation -> annotation.symbolType().is(VALUE_ANNOTATION) && !NullableInjectedFieldsHaveDefaultValueCheck.hasDefaultValue(annotation)).findFirst();
    }

    private static boolean hasDefaultValue(AnnotationTree valueAnnotation) {
        ExpressionTree expression = (ExpressionTree)valueAnnotation.arguments().get(0);
        String value = NullableInjectedFieldsHaveDefaultValueCheck.extractLiteralValue(expression);
        String argument = value.strip();
        if (argument.startsWith("${") && argument.endsWith("}")) {
            return argument.contains(":");
        }
        return true;
    }

    private static String extractLiteralValue(ExpressionTree annotationArgument) {
        ExpressionTree expressionTree = NullableInjectedFieldsHaveDefaultValueCheck.extractExpressionTree(annotationArgument);
        String value = ExpressionsHelper.getConstantValueAsString(expressionTree).value();
        return value != null ? value : "";
    }

    private static ExpressionTree extractExpressionTree(ExpressionTree annotationArgument) {
        if (annotationArgument.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            return ((AssignmentExpressionTree)annotationArgument).expression();
        }
        return annotationArgument;
    }

    private static class AnnotationsOfInterest {
        public final AnnotationTree valueAnnotation;
        public final AnnotationTree nullableAnnotation;

        public AnnotationsOfInterest(AnnotationTree valueAnnotation, AnnotationTree nullableAnnotation) {
            this.valueAnnotation = valueAnnotation;
            this.nullableAnnotation = nullableAnnotation;
        }
    }
}

